/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.mixin;

import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.init.ModRegistry;
import fuzs.easymagic.util.ChiseledBookshelfHelper;
import fuzs.easymagic.world.inventory.ModEnchantmentMenu;
import fuzs.easymagic.world.level.block.entity.ModEnchantmentTableBlockEntity;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentTableBlock.class}, priority=500)
abstract class EnchantmentTableBlockMixin
extends BaseEntityBlock {
    protected EnchantmentTableBlockMixin(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Inject(method={"newBlockEntity"}, at={@At(value="HEAD")}, cancellable=true)
    public void newBlockEntity(BlockPos pos, BlockState state, CallbackInfoReturnable<BlockEntity> callbackInfo) {
        callbackInfo.setReturnValue((Object)((BlockEntityType)ModRegistry.ENCHANTING_TABLE_BLOCK_ENTITY_TYPE.get()).m_155264_(pos, state));
    }

    @Inject(method={"getTicker"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends BlockEntity> void getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType, CallbackInfoReturnable<BlockEntityTicker<T>> callbackInfo) {
        callbackInfo.setReturnValue(pLevel.f_46443_ ? EnchantmentTableBlockMixin.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModRegistry.ENCHANTING_TABLE_BLOCK_ENTITY_TYPE.get()), EnchantmentTableBlockEntity::m_155503_) : null);
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> callbackInfo) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (!worldIn.f_46443_ && tileentity instanceof ModEnchantmentTableBlockEntity) {
            player.m_5893_((MenuProvider)tileentity);
            if (player.f_36096_ instanceof ModEnchantmentMenu) {
                player.f_36096_.m_6199_((Container)tileentity);
            }
            callbackInfo.setReturnValue((Object)InteractionResult.CONSUME);
        }
    }

    @Inject(method={"isValidBookShelf"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isValidBookShelf(Level level, BlockPos pos, BlockPos offset, CallbackInfoReturnable<Boolean> callback) {
        if (CommonAbstractions.INSTANCE.getEnchantPowerBonus(level.m_8055_(pos.m_121955_((Vec3i)offset)), level, pos.m_121955_((Vec3i)offset)) == 0.0f && ChiseledBookshelfHelper.findValidBooks(level, pos, offset) == 0) {
            callback.setReturnValue((Object)false);
            return;
        }
        BlockPos inBetweenPos = pos.m_7918_(offset.m_123341_() / 2, offset.m_123342_(), offset.m_123343_() / 2);
        boolean isEmpty = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).lenientBookshelves ? level.m_8055_(inBetweenPos).m_60812_((BlockGetter)level, inBetweenPos) != Shapes.m_83144_() : level.m_46859_(inBetweenPos);
        callback.setReturnValue((Object)isEmpty);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity;
        if (!state.m_60713_(newState.m_60734_()) && (tileentity = worldIn.m_7702_(pos)) instanceof ModEnchantmentTableBlockEntity) {
            Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((Container)tileentity));
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof Container) {
            ItemStack catalystItem = ((Container)tileentity).m_8020_(1);
            return Math.min(catalystItem.m_41613_(), 3);
        }
        return 0;
    }
}

