/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.surfaceRules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6686;
import net.minecraft.class_7924;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.config.Configs;
import org.betterx.worlds.together.chunkgenerator.InjectableSurfaceRules;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleProvider;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleRegistry;
import org.betterx.worlds.together.world.event.WorldBootstrap;

public class SurfaceRuleUtil {
    private static List<class_6686.class_6708> getRulesForBiome(class_2960 biomeID) {
        class_2378 registry = null;
        if (WorldBootstrap.getLastRegistryAccess() != null) {
            registry = WorldBootstrap.getLastRegistryAccess().method_30530(SurfaceRuleRegistry.SURFACE_RULES_REGISTRY);
        }
        if (registry == null) {
            return List.of();
        }
        return registry.method_10220().filter(a -> a != null && a.biomeID != null && a.biomeID.equals((Object)biomeID)).map(a -> a.ruleSource).toList();
    }

    private static List<class_6686.class_6708> getRulesForBiomes(List<class_1959> biomes) {
        class_2378 biomeRegistry = WorldBootstrap.getLastRegistryAccess().method_30530(class_7924.field_41236);
        List<class_2960> biomeIDs = biomes.stream().map(b -> biomeRegistry.method_10221(b)).filter(id -> id != null).toList();
        return biomeIDs.stream().map(biomeID -> SurfaceRuleUtil.getRulesForBiome(biomeID)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedList::new));
    }

    private static class_6686.class_6708 mergeSurfaceRules(class_5321<class_5363> dimensionKey, class_6686.class_6708 org, class_1966 source, List<class_6686.class_6708> additionalRules) {
        if (additionalRules == null || additionalRules.isEmpty()) {
            return null;
        }
        int count = additionalRules.size();
        if (org instanceof class_6686.class_6710) {
            class_6686.class_6710 sequenceRule = (class_6686.class_6710)org;
            List existingSequence = sequenceRule.comp_209();
            if ((additionalRules = additionalRules.stream().filter(r -> existingSequence.indexOf(r) < 0).collect(Collectors.toList())).isEmpty()) {
                return null;
            }
            if (dimensionKey.equals((Object)class_5363.field_25413)) {
                ArrayList<Object> combined = new ArrayList<Object>(existingSequence.size() + additionalRules.size());
                for (class_6686.class_6708 rule : existingSequence) {
                    class_6686.class_6718 testRule;
                    if (rule instanceof class_6686.class_6718 && (testRule = (class_6686.class_6718)rule).comp_215() instanceof class_6686.class_6689) {
                        combined.addAll(additionalRules);
                    }
                    combined.add(rule);
                }
                additionalRules = combined;
            } else {
                additionalRules.addAll(existingSequence);
            }
        } else if (!additionalRules.contains(org)) {
            additionalRules.add(org);
        }
        if (Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info("Merged " + count + " additional Surface Rules for " + source + " => " + additionalRules.size());
        }
        return new class_6686.class_6710(additionalRules);
    }

    public static void injectSurfaceRules(class_5321<class_5363> dimensionKey, class_5284 noiseSettings, class_1966 loadedBiomeSource) {
        class_5284 class_52842 = noiseSettings;
        if (class_52842 instanceof SurfaceRuleProvider) {
            SurfaceRuleProvider srp = (SurfaceRuleProvider)class_52842;
            class_6686.class_6708 originalRules = srp.bclib_getOriginalSurfaceRules();
            srp.bclib_overwriteSurfaceRules(SurfaceRuleUtil.mergeSurfaceRules(dimensionKey, originalRules, loadedBiomeSource, SurfaceRuleUtil.getRulesForBiomes(loadedBiomeSource.method_28443().stream().map(h -> (class_1959)h.comp_349()).toList())));
        }
    }

    public static void injectSurfaceRulesToAllDimensions(class_2378<class_5363> dimensionRegistry) {
        for (Map.Entry entry : dimensionRegistry.method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            class_5363 stem = (class_5363)entry.getValue();
            class_2794 class_27942 = stem.comp_1013();
            if (!(class_27942 instanceof InjectableSurfaceRules)) continue;
            InjectableSurfaceRules generator = (InjectableSurfaceRules)class_27942;
            generator.injectSurfaceRules((class_5321<class_5363>)key);
        }
    }
}

