/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.network;

import com.leclowndu93150.leaderboards.data.Leaderboard;
import com.leclowndu93150.leaderboards.data.LeaderboardValue;
import com.leclowndu93150.leaderboards.data.PlayerDataTracker;
import com.leclowndu93150.leaderboards.data.PlayerStatsWrapper;
import com.leclowndu93150.leaderboards.gui.LeaderboardScreen;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.network.NetworkEvent;

public class LeaderboardResponsePacket {
    private final Component title;
    private final List<LeaderboardValue> values;

    public LeaderboardResponsePacket(Component title, List<LeaderboardValue> values) {
        this.title = title;
        this.values = values;
    }

    public LeaderboardResponsePacket(ServerPlayer requestingPlayer, Leaderboard leaderboard) {
        this(leaderboard.getTitle(), LeaderboardResponsePacket.createValues(requestingPlayer, leaderboard));
    }

    public static void encode(LeaderboardResponsePacket packet, FriendlyByteBuf buf) {
        buf.m_130083_(packet.title);
        buf.m_130130_(packet.values.size());
        for (LeaderboardValue value : packet.values) {
            buf.m_130070_(value.username);
            buf.m_130083_(value.value);
            buf.writeByte(value.color.m_126656_());
        }
    }

    public static LeaderboardResponsePacket decode(FriendlyByteBuf buf) {
        Component title = buf.m_130238_();
        int size = buf.m_130242_();
        ArrayList<LeaderboardValue> values = new ArrayList<LeaderboardValue>();
        for (int i = 0; i < size; ++i) {
            LeaderboardValue value = new LeaderboardValue();
            value.username = buf.m_130277_();
            value.value = buf.m_130238_();
            value.color = ChatFormatting.m_126647_((int)buf.readByte());
            values.add(value);
        }
        return new LeaderboardResponsePacket(title, values);
    }

    private static ServerStatsCounter loadPlayerStats(MinecraftServer server, UUID uuid) {
        File statsDir = server.m_129843_(LevelResource.f_78175_).toFile();
        File statsFile = new File(statsDir, uuid.toString() + ".json");
        return new ServerStatsCounter(server, statsFile);
    }

    private static List<LeaderboardValue> createValues(ServerPlayer requestingPlayer, Leaderboard leaderboard) {
        ArrayList<LeaderboardValue> values = new ArrayList<LeaderboardValue>();
        ArrayList<PlayerStatsWrapper> players = new ArrayList<PlayerStatsWrapper>();
        PlayerDataTracker tracker = PlayerDataTracker.get(requestingPlayer.f_8924_.m_129783_());
        for (ServerPlayer onlinePlayer : requestingPlayer.f_8924_.m_6846_().m_11314_()) {
            players.add(new PlayerStatsWrapper(onlinePlayer));
        }
        tracker.getAllPlayerUUIDs().forEach(uuid -> {
            GameProfile profile;
            if (requestingPlayer.f_8924_.m_6846_().m_11259_(uuid) == null && (profile = (GameProfile)requestingPlayer.f_8924_.m_129927_().m_11002_(uuid).orElse(null)) != null) {
                ServerStatsCounter stats = LeaderboardResponsePacket.loadPlayerStats(requestingPlayer.f_8924_, uuid);
                players.add(new PlayerStatsWrapper((UUID)uuid, profile, stats, requestingPlayer.f_8924_));
            }
        });
        players.sort(leaderboard.getComparator());
        for (int i = 0; i < players.size(); ++i) {
            PlayerStatsWrapper player = (PlayerStatsWrapper)players.get(i);
            LeaderboardValue value = new LeaderboardValue();
            value.username = player.getGameProfile().getName();
            value.value = leaderboard.createValue(player);
            value.color = player.getUUID().equals(requestingPlayer.m_20148_()) ? ChatFormatting.DARK_GREEN : (!leaderboard.hasValidValue(player) ? ChatFormatting.DARK_GRAY : (i < 3 ? ChatFormatting.GOLD : ChatFormatting.RESET));
            values.add(value);
        }
        return values;
    }

    public static void handle(LeaderboardResponsePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Minecraft.m_91087_().execute(() -> {
            LeaderboardScreen screen = new LeaderboardScreen(packet.title, packet.values);
            screen.openGui();
        }));
        ctx.get().setPacketHandled(true);
    }
}

