/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.gui;

import com.leclowndu93150.leaderboards.Leaderboards;
import com.leclowndu93150.leaderboards.VanillaStatsRegistry;
import com.leclowndu93150.leaderboards.data.Leaderboard;
import com.leclowndu93150.leaderboards.gui.VanillaStatsListScreen;
import com.leclowndu93150.leaderboards.network.RequestLeaderboardPacket;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class LeaderboardListScreen
extends ButtonListBaseScreen {
    private final Map<ResourceLocation, Component> leaderboards;

    public LeaderboardListScreen(Map<ResourceLocation, Component> leaderboards) {
        this.leaderboards = leaderboards;
        this.setTitle((Component)Component.m_237115_((String)"sidebar_button.leaderboards.leaderboards"));
    }

    public void addButtons(Panel panel) {
        for (final Map.Entry<ResourceLocation, Component> entry : this.leaderboards.entrySet()) {
            panel.add((Widget)new SimpleTextButton(panel, entry.getValue(), (Icon)Icon.empty()){

                public void onClicked(MouseButton button) {
                    this.playClickSound();
                    Leaderboards.NETWORK.sendToServer((Object)new RequestLeaderboardPacket((ResourceLocation)entry.getKey()));
                }
            });
        }
        if (!VanillaStatsRegistry.VANILLA_STATS.isEmpty()) {
            panel.add((Widget)new SimpleTextButton(panel, (Component)Component.m_237115_((String)"leaderboard.leaderboards.vanilla_stats"), (Icon)Icon.empty()){

                public void onClicked(MouseButton button) {
                    this.playClickSound();
                    LinkedHashMap<ResourceLocation, Component> vanillaStatsMap = new LinkedHashMap<ResourceLocation, Component>();
                    VanillaStatsRegistry.VANILLA_STATS.entrySet().stream().sorted((e1, e2) -> ((Leaderboard)e1.getValue()).getTitle().getString().compareToIgnoreCase(((Leaderboard)e2.getValue()).getTitle().getString())).forEach(entry -> vanillaStatsMap.put((ResourceLocation)entry.getKey(), ((Leaderboard)entry.getValue()).getTitle()));
                    new VanillaStatsListScreen(vanillaStatsMap).openGui();
                }
            });
        }
    }
}

