/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards;

import com.leclowndu93150.leaderboards.VanillaStatsRegistry;
import com.leclowndu93150.leaderboards.data.Leaderboard;
import com.leclowndu93150.leaderboards.data.PlayerDataTracker;
import com.leclowndu93150.leaderboards.data.PlayerStatsWrapper;
import com.leclowndu93150.leaderboards.integration.FTBQuestsIntegration;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;

public class LeaderboardRegistry {
    public static final Map<ResourceLocation, Leaderboard> LEADERBOARDS = new LinkedHashMap<ResourceLocation, Leaderboard>();

    public static void register() {
        LEADERBOARDS.put(new ResourceLocation("leaderboards", "deaths"), new Leaderboard.FromStat(new ResourceLocation("leaderboards", "deaths"), (Component)Component.m_237115_((String)"leaderboard.leaderboards.deaths"), Stats.f_12988_.m_12902_((Object)Stats.f_12935_), false));
        LEADERBOARDS.put(new ResourceLocation("leaderboards", "mob_kills"), new Leaderboard.FromStat(new ResourceLocation("leaderboards", "mob_kills"), (Component)Component.m_237115_((String)"leaderboard.leaderboards.mob_kills"), Stats.f_12988_.m_12902_((Object)Stats.f_12936_), false));
        LEADERBOARDS.put(new ResourceLocation("leaderboards", "player_kills"), new Leaderboard.FromStat(new ResourceLocation("leaderboards", "player_kills"), (Component)Component.m_237115_((String)"leaderboard.leaderboards.player_kills"), Stats.f_12988_.m_12902_((Object)Stats.f_12938_), false));
        LEADERBOARDS.put(new ResourceLocation("leaderboards", "time_played"), new Leaderboard.FromStat(new ResourceLocation("leaderboards", "time_played"), (Component)Component.m_237115_((String)"leaderboard.leaderboards.time_played"), Stats.f_12988_.m_12902_((Object)Stats.f_144255_), false, Leaderboard.FromStat.TIME));
        LEADERBOARDS.put(new ResourceLocation("leaderboards", "jumps"), new Leaderboard.FromStat(new ResourceLocation("leaderboards", "jumps"), (Component)Component.m_237115_((String)"leaderboard.leaderboards.jumps"), Stats.f_12988_.m_12902_((Object)Stats.f_12926_), false));
        LEADERBOARDS.put(new ResourceLocation("leaderboards", "distance_walked"), new Leaderboard.FromStat(new ResourceLocation("leaderboards", "distance_walked"), (Component)Component.m_237115_((String)"leaderboard.leaderboards.distance_walked"), Stats.f_12988_.m_12902_((Object)Stats.f_12994_), false, Leaderboard.FromStat.DISTANCE));
        LEADERBOARDS.put(new ResourceLocation("leaderboards", "distance_sprinted"), new Leaderboard.FromStat(new ResourceLocation("leaderboards", "distance_sprinted"), (Component)Component.m_237115_((String)"leaderboard.leaderboards.distance_sprinted"), Stats.f_12988_.m_12902_((Object)Stats.f_12996_), false, Leaderboard.FromStat.DISTANCE));
        LEADERBOARDS.put(new ResourceLocation("leaderboards", "deaths_per_hour"), new Leaderboard(new ResourceLocation("leaderboards", "deaths_per_hour"), (Component)Component.m_237115_((String)"leaderboard.leaderboards.deaths_per_hour"), player -> {
            double dph = LeaderboardRegistry.getDPH(player);
            return Component.m_237113_((String)(dph < 0.0 ? "-" : String.format("%.2f", dph)));
        }, Comparator.comparingDouble(LeaderboardRegistry::getDPH).reversed(), player -> LeaderboardRegistry.getDPH(player) >= 0.0));
        LEADERBOARDS.put(new ResourceLocation("leaderboards", "last_seen"), new Leaderboard(new ResourceLocation("leaderboards", "last_seen"), (Component)Component.m_237115_((String)"leaderboard.leaderboards.last_seen"), player -> {
            if (player.server.m_6846_().m_11259_(player.getUUID()) != null) {
                return Component.m_237115_((String)"gui.online").m_130940_(ChatFormatting.GREEN);
            }
            long lastSeen = PlayerDataTracker.getLastSeen(player.getUUID());
            if (lastSeen == 0L) {
                return Component.m_237113_((String)"-");
            }
            long worldTime = player.server.m_129783_().m_46467_();
            int time = (int)(worldTime - lastSeen);
            return Leaderboard.FromStat.TIME.apply(time);
        }, Comparator.comparingLong(p -> {
            if (p.server.m_6846_().m_11259_(p.getUUID()) != null) {
                return 0L;
            }
            return p.server.m_129783_().m_46467_() - PlayerDataTracker.getLastSeen(p.getUUID());
        }), player -> PlayerDataTracker.getLastSeen(player.getUUID()) != 0L || player.server.m_6846_().m_11259_(player.getUUID()) != null));
        if (FTBQuestsIntegration.isAvailable()) {
            LEADERBOARDS.put(new ResourceLocation("leaderboards", "quest_completions"), new Leaderboard(new ResourceLocation("leaderboards", "quest_completions"), (Component)Component.m_237115_((String)"leaderboard.leaderboards.quest_completions"), player -> Component.m_237113_((String)String.valueOf(FTBQuestsIntegration.getPlayerQuestCompletions(player))), Comparator.comparingInt(FTBQuestsIntegration::getPlayerQuestCompletions).reversed(), player -> FTBQuestsIntegration.getPlayerQuestCompletions(player) > 0));
            LEADERBOARDS.put(new ResourceLocation("leaderboards", "quest_completion_percentage"), new Leaderboard(new ResourceLocation("leaderboards", "quest_completion_percentage"), (Component)Component.m_237115_((String)"leaderboard.leaderboards.quest_completion_percentage"), player -> {
                double percentage = FTBQuestsIntegration.getQuestCompletionPercentage(player);
                return Component.m_237113_((String)String.format("%.1f%%", percentage));
            }, Comparator.comparingDouble(FTBQuestsIntegration::getQuestCompletionPercentage).reversed(), player -> FTBQuestsIntegration.getPlayerQuestCompletions(player) > 0));
        }
        VanillaStatsRegistry.register();
    }

    private static double getDPH(PlayerStatsWrapper player) {
        double hours;
        int playTime = player.getStats().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_144255_));
        if (playTime > 0 && (hours = (double)playTime / 72000.0) >= 1.0) {
            return (double)player.getStats().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_)) / hours;
        }
        return -1.0;
    }
}

