/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.simulation;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.simulation.SimulationNode;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.leclowndu93150.wakes.utils.WakesUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WakeNode {
    public final SimulationNode simulationNode = new SimulationNode.WakeSimulation();
    public final int x;
    public final int y;
    public final int z;
    public static final float WATER_OFFSET = 0.8888889f;
    public WakeNode NORTH = null;
    public WakeNode EAST = null;
    public WakeNode SOUTH = null;
    public WakeNode WEST = null;
    public static int maxAge = 30;
    public int age = 0;
    private boolean dead = false;
    public float t = 0.0f;
    public int floodLevel;

    public WakeNode(int x, int y, int z, int floodLevel) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.floodLevel = floodLevel;
    }

    private WakeNode(long pos, int y) {
        int[] xz = WakesUtils.longAsPos(pos);
        this.x = xz[0];
        this.y = y;
        this.z = xz[1];
        this.floodLevel = (Integer)WakesConfig.DEBUG.floodFillDistance.get();
    }

    public SimulationNode getSimulationNode(WakeNode neighboringNode) {
        if (neighboringNode == null) {
            return null;
        }
        return neighboringNode.simulationNode;
    }

    public boolean tick(WakeHandler wakeHandler) {
        if (this.isDead()) {
            return false;
        }
        if (this.age++ >= maxAge) {
            this.markDead();
            return false;
        }
        this.t = (float)this.age / (float)maxAge;
        this.simulationNode.tick(null, this.getSimulationNode(this.NORTH), this.getSimulationNode(this.SOUTH), this.getSimulationNode(this.EAST), this.getSimulationNode(this.WEST));
        this.floodFill(wakeHandler);
        return true;
    }

    public void floodFill(WakeHandler wakeHandler) {
        if (this.floodLevel > 0 && this.age > (Integer)WakesConfig.DEBUG.floodFillTickDelay.get()) {
            if (this.NORTH == null) {
                wakeHandler.insert(new WakeNode(this.x, this.y, this.z - 1, this.floodLevel - 1));
            } else {
                this.NORTH.updateFloodLevel(this.floodLevel - 1);
            }
            if (this.EAST == null) {
                wakeHandler.insert(new WakeNode(this.x + 1, this.y, this.z, this.floodLevel - 1));
            } else {
                this.EAST.updateFloodLevel(this.floodLevel - 1);
            }
            if (this.SOUTH == null) {
                wakeHandler.insert(new WakeNode(this.x, this.y, this.z + 1, this.floodLevel - 1));
            } else {
                this.SOUTH.updateFloodLevel(this.floodLevel - 1);
            }
            if (this.WEST == null) {
                wakeHandler.insert(new WakeNode(this.x - 1, this.y, this.z, this.floodLevel - 1));
            } else {
                this.WEST.updateFloodLevel(this.floodLevel - 1);
            }
            this.floodLevel = 0;
        }
    }

    public void updateAdjacency(WakeNode node) {
        if (node.x == this.x && node.z == this.z - 1) {
            this.NORTH = node;
            node.SOUTH = this;
            return;
        }
        if (node.x == this.x + 1 && node.z == this.z) {
            this.EAST = node;
            node.WEST = this;
            return;
        }
        if (node.x == this.x && node.z == this.z + 1) {
            this.SOUTH = node;
            node.NORTH = this;
            return;
        }
        if (node.x == this.x - 1 && node.z == this.z) {
            this.WEST = node;
            node.EAST = this;
        }
    }

    public void updateFloodLevel(int newLevel) {
        this.age = 0;
        if (newLevel > this.floodLevel) {
            this.floodLevel = newLevel;
        }
    }

    public boolean validPos(Level world) {
        FluidState fluidState = world.m_6425_(this.blockPos());
        FluidState fluidStateAbove = world.m_6425_(this.blockPos().m_7494_());
        if (WakesConfig.getFluidWhitelist().contains(fluidState.m_76152_()) && fluidStateAbove.m_76178_()) {
            return fluidState.m_76170_();
        }
        return false;
    }

    public AABB toBox() {
        return new AABB((double)this.x, (double)this.y, (double)this.z, (double)(this.x + 1), (double)((float)this.y + 0.111111104f), (double)(this.z + 1));
    }

    public void revive(WakeNode node) {
        this.age = 0;
        this.floodLevel = (Integer)WakesConfig.DEBUG.floodFillDistance.get();
        this.simulationNode.initialValues = node.simulationNode.initialValues;
    }

    public void markDead() {
        this.dead = true;
    }

    public boolean isDead() {
        return this.dead;
    }

    public BlockPos blockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WakeNode wakeNode = (WakeNode)o;
        return this.x == wakeNode.x && this.z == wakeNode.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public String toString() {
        return String.format("WakeNode{%d, %d, %d}", this.x, this.y, this.z);
    }

    public static class Factory {
        public static Set<WakeNode> splashNodes(Entity entity, int y) {
            int res = WakeHandler.resolution.res;
            int w = (int)(0.8 * (double)entity.m_20205_() * (double)res / 2.0);
            int x = (int)(entity.m_20185_() * (double)res);
            int z = (int)(entity.m_20189_() * (double)res);
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            for (int i = -w; i < w; ++i) {
                for (int j = -w; j < w; ++j) {
                    if (i * i + j * j >= w * w) continue;
                    pixelsAffected.add(WakesUtils.posAsLong(x + i, z + j));
                }
            }
            return Factory.pixelsToNodes(pixelsAffected, y, ((Integer)WakesConfig.GENERAL.splashStrength.get()).intValue(), Math.abs(entity.m_20184_().f_82480_));
        }

        public static Set<WakeNode> rowingNodes(Boat boat, int y) {
            HashSet<WakeNode> nodesAffected = new HashSet<WakeNode>();
            double velocity = boat.m_20184_().m_165924_();
            for (int i = 0; i < 2; ++i) {
                double phase;
                if (!boat.m_38313_(i) || !(0.19634954631328583 <= (phase = (double)boat.f_38263_[i] % (Math.PI * 2))) || !(phase <= 1.178097277879715)) continue;
                Vec3 rot = boat.m_20252_(1.0f);
                double x = boat.m_20185_() + (i == 1 ? -rot.f_82481_ : rot.f_82481_);
                double z = boat.m_20189_() + (i == 1 ? rot.f_82479_ : -rot.f_82479_);
                Vec3 paddlePos = new Vec3(x, (double)y, z);
                Vec3 dir = Vec3.m_82498_((float)0.0f, (float)boat.m_146908_()).m_82490_(velocity);
                Vec3 from = paddlePos;
                Vec3 to = paddlePos.m_82549_(dir.m_82490_(2.0));
                nodesAffected.addAll(Factory.nodeTrail(from.f_82479_, from.f_82481_, to.f_82479_, to.f_82481_, y, ((Integer)WakesConfig.GENERAL.paddleStrength.get()).intValue(), velocity));
            }
            return nodesAffected;
        }

        public static Set<WakeNode> nodeTrail(double fromX, double fromZ, double toX, double toZ, int y, float waveStrength, double velocity) {
            int res = WakeHandler.resolution.res;
            int x1 = (int)(fromX * (double)res);
            int z1 = (int)(fromZ * (double)res);
            int x2 = (int)(toX * (double)res);
            int z2 = (int)(toZ * (double)res);
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            WakesUtils.bresenhamLine(x1, z1, x2, z2, pixelsAffected);
            return Factory.pixelsToNodes(pixelsAffected, y, waveStrength, velocity);
        }

        public static Set<WakeNode> thickNodeTrail(double fromX, double fromZ, double toX, double toZ, int y, float waveStrength, double velocity, float width) {
            double distanceSq = (toX - fromX) * (toX - fromX) + (toZ - fromZ) * (toZ - fromZ);
            if (distanceSq > 400.0) {
                return new HashSet<WakeNode>();
            }
            int res = WakeHandler.resolution.res;
            int x1 = (int)(fromX * (double)res);
            int z1 = (int)(fromZ * (double)res);
            int x2 = (int)(toX * (double)res);
            int z2 = (int)(toZ * (double)res);
            int w = (int)(0.8 * (double)width * (double)res / 2.0);
            float len = (float)Math.sqrt(Math.pow(z1 - z2, 2.0) + Math.pow(x2 - x1, 2.0));
            if (len > 1000.0f) {
                return new HashSet<WakeNode>();
            }
            float nx = (float)(z1 - z2) / len;
            float nz = (float)(x2 - x1) / len;
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            for (int i = -w; i < w; ++i) {
                WakesUtils.bresenhamLine((int)((float)x1 + nx * (float)i), (int)((float)z1 + nz * (float)i), (int)((float)x2 + nx * (float)i), (int)((float)z2 + nz * (float)i), pixelsAffected);
            }
            return Factory.pixelsToNodes(pixelsAffected, y, waveStrength, velocity);
        }

        public static Set<WakeNode> nodeLine(double x, int y, double z, float waveStrength, Vec3 velocity, float width) {
            int res = WakeHandler.resolution.res;
            Vec3 dir = velocity.m_82541_();
            double nx = -dir.f_82481_;
            double nz = dir.f_82479_;
            int w = (int)(0.8 * (double)width * (double)res / 2.0);
            int x1 = (int)(x * (double)res - nx * (double)w);
            int z1 = (int)(z * (double)res - nz * (double)w);
            int x2 = (int)(x * (double)res + nx * (double)w);
            int z2 = (int)(z * (double)res + nz * (double)w);
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            WakesUtils.bresenhamLine(x1, z1, x2, z2, pixelsAffected);
            return Factory.pixelsToNodes(pixelsAffected, y, waveStrength, velocity.m_165924_());
        }

        private static Set<WakeNode> pixelsToNodes(ArrayList<Long> pixelsAffected, int y, float waveStrength, double velocity) {
            int res = WakeHandler.resolution.res;
            int power = (int)(Math.log(res) / Math.log(2.0));
            HashMap pixelsInNodes = new HashMap();
            for (Long pixel : pixelsAffected) {
                int[] pos = WakesUtils.longAsPos(pixel);
                long k = WakesUtils.posAsLong(pos[0] >> power, pos[1] >> power);
                pos[0] = pos[0] % res;
                pos[1] = pos[1] % res;
                long v = WakesUtils.posAsLong(pos[0], pos[1]);
                if (pixelsInNodes.containsKey(k)) {
                    ((HashSet)pixelsInNodes.get(k)).add(v);
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(v);
                pixelsInNodes.put(k, set);
            }
            HashSet<WakeNode> nodesAffected = new HashSet<WakeNode>();
            for (Long nodePos : pixelsInNodes.keySet()) {
                WakeNode node = new WakeNode(nodePos, y);
                for (Long subPos : (HashSet)pixelsInNodes.get(nodePos)) {
                    node.simulationNode.setInitialValue(subPos, (int)((double)waveStrength * velocity));
                }
                nodesAffected.add(node);
            }
            return nodesAffected;
        }
    }
}

