/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.mixin;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.config.enums.EffectSpawningRule;
import com.leclowndu93150.wakes.duck.ProducesWake;
import com.leclowndu93150.wakes.particle.custom.SplashPlaneParticle;
import com.leclowndu93150.wakes.utils.WakesUtils;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class WakeSpawnerMixin
implements ProducesWake {
    @Shadow
    private Vec3 f_19825_;
    @Shadow
    private Level f_19853_;
    @Unique
    private boolean onFluidSurface = false;
    @Unique
    private Vec3 prevPosOnSurface = null;
    @Unique
    private Vec3 numericalVelocity = Vec3.f_82478_;
    @Unique
    private double horizontalNumericalVelocity = 0.0;
    @Unique
    private Float wakeHeight = null;
    @Unique
    private SplashPlaneParticle splashPlane;
    @Unique
    private boolean hasRecentlyTeleported = false;

    @Shadow
    public abstract String toString();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract boolean m_20069_();

    @Override
    public boolean wakes$onFluidSurface() {
        return this.onFluidSurface;
    }

    @Override
    public Vec3 wakes$getNumericalVelocity() {
        return this.numericalVelocity;
    }

    @Override
    public double wakes$getHorizontalVelocity() {
        return this.horizontalNumericalVelocity;
    }

    @Override
    public Vec3 wakes$getPrevPos() {
        return this.prevPosOnSurface;
    }

    @Override
    public void wakes$setPrevPos(Vec3 pos) {
        this.prevPosOnSurface = pos;
    }

    @Override
    public Float wakes$wakeHeight() {
        return this.wakeHeight;
    }

    @Override
    public void wakes$setWakeHeight(float h) {
        this.wakeHeight = Float.valueOf(h);
    }

    @Override
    public void wakes$setSplashPlane(SplashPlaneParticle particle) {
        this.splashPlane = particle;
    }

    @Override
    public void wakes$setRecentlyTeleported(boolean b) {
        this.hasRecentlyTeleported = b;
    }

    @Override
    public SplashPlaneParticle wakes$getSplashPlane() {
        return this.splashPlane;
    }

    @Inject(at={@At(value="HEAD")}, method={"teleportTo(DDD)V"})
    private void onTeleportTo(double x, double y, double z, CallbackInfo ci) {
        Vec3 currentPos = this.f_19825_;
        Vec3 newPos = new Vec3(x, y, z);
        double distanceSq = currentPos.m_82557_(newPos);
        if (distanceSq > 400.0) {
            this.wakes$setRecentlyTeleported(true);
            this.wakes$setPrevPos(null);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"moveTo(DDDFF)V"})
    private void onMoveTo(double x, double y, double z, float yaw, float pitch, CallbackInfo ci) {
        Vec3 currentPos = this.f_19825_;
        Vec3 newPos = new Vec3(x, y, z);
        if (currentPos.m_82557_(newPos) > 400.0) {
            this.wakes$setRecentlyTeleported(true);
            this.wakes$setPrevPos(null);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setPos(DDD)V"})
    private void onSetPos(double x, double y, double z, CallbackInfo ci) {
        Vec3 newPos;
        Vec3 currentPos;
        double distanceSq;
        if (this.f_19825_ != null && (distanceSq = (currentPos = this.f_19825_).m_82557_(newPos = new Vec3(x, y, z))) > 100.0) {
            this.wakes$setRecentlyTeleported(true);
            this.wakes$setPrevPos(null);
        }
    }

    @Unique
    private boolean onFluidSurface() {
        AABB box = this.m_20191_();
        double hitboxMaxY = box.f_82292_;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int y = (int)Math.floor(box.f_82289_); y <= (int)Math.floor(hitboxMaxY); ++y) {
            blockPos.m_122169_(this.m_20185_(), (double)y, this.m_20189_());
            FluidState fluidState = this.f_19853_.m_6425_((BlockPos)blockPos);
            if (fluidState.m_76178_() || !WakesConfig.getFluidWhitelist().contains(fluidState.m_76152_())) continue;
            double fluidHeight = (float)blockPos.m_123342_() + fluidState.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockPos);
            return hitboxMaxY > fluidHeight;
        }
        return false;
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        Vec3 vel;
        if (!this.f_19853_.f_46443_) {
            return;
        }
        this.onFluidSurface = this.onFluidSurface();
        Entity thisEntity = (Entity)this;
        this.numericalVelocity = vel = this.calculateVelocity(thisEntity);
        this.horizontalNumericalVelocity = vel.m_165924_();
        if (((Boolean)WakesConfig.GENERAL.disableMod.get()).booleanValue()) {
            return;
        }
        if (this.onFluidSurface && !this.hasRecentlyTeleported) {
            this.wakeHeight = Float.valueOf(WakesUtils.getFluidLevel(this.f_19853_, thisEntity));
            Vec3 currPos = new Vec3(thisEntity.m_20185_(), (double)this.wakeHeight.floatValue(), thisEntity.m_20189_());
            this.spawnEffects(thisEntity);
            this.wakes$setPrevPos(currPos);
        } else {
            this.wakeHeight = null;
            this.prevPosOnSurface = null;
        }
        this.wakes$setRecentlyTeleported(false);
    }

    @Inject(at={@At(value="TAIL")}, method={"doWaterSplashEffect"})
    private void onSwimmingStart(CallbackInfo ci) {
        if (((Boolean)WakesConfig.GENERAL.disableMod.get()).booleanValue()) {
            return;
        }
        Entity thisEntity = (Entity)this;
        EffectSpawningRule rule = WakesUtils.getEffectRuleFromSource(thisEntity);
        if (rule.simulateWakes) {
            if (this.wakeHeight == null) {
                this.wakeHeight = Float.valueOf(WakesUtils.getFluidLevel(this.f_19853_, thisEntity));
            }
            WakesUtils.placeFallSplash((Entity)this);
        }
    }

    @Unique
    private void spawnEffects(Entity thisEntity) {
        EffectSpawningRule rule = WakesUtils.getEffectRuleFromSource(thisEntity);
        if (rule.simulateWakes) {
            WakesUtils.placeWakeTrail(thisEntity);
        }
        if (rule.renderPlanes && this.splashPlane == null && this.horizontalNumericalVelocity > 0.01) {
            WakesUtils.spawnSplashPlane(this.f_19853_, thisEntity);
        }
    }

    @Unique
    private Vec3 calculateVelocity(Entity thisEntity) {
        if (thisEntity instanceof LocalPlayer) {
            return thisEntity.m_20184_();
        }
        return this.prevPosOnSurface == null ? Vec3.f_82478_ : this.f_19825_.m_82546_(this.prevPosOnSurface);
    }
}

