/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.debug;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.simulation.Brick;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.leclowndu93150.wakes.simulation.WakeNode;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class WakeDebugRenderer {
    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        WakeHandler wakeHandler = WakeHandler.getInstance().orElse(null);
        if (wakeHandler == null) {
            return;
        }
        if (((Boolean)WakesConfig.DEBUG.drawDebugBoxes.get()).booleanValue()) {
            PoseStack poseStack = event.getPoseStack();
            MultiBufferSource.BufferSource bufferSource = event.getLevelRenderer().f_109464_.m_110104_();
            Vec3 cameraPos = event.getCamera().m_90583_();
            for (WakeNode node : wakeHandler.getVisible(event.getFrustum(), WakeNode.class)) {
                DebugRenderer.m_269311_((PoseStack)poseStack, (MultiBufferSource)bufferSource, (AABB)node.toBox().m_82383_(cameraPos.m_82548_()), (float)1.0f, (float)0.0f, (float)1.0f, (float)0.5f);
            }
            for (Brick brick : wakeHandler.getVisible(event.getFrustum(), Brick.class)) {
                Vec3 pos = brick.pos;
                AABB box = new AABB(pos.f_82479_, pos.f_82480_ - 0.1111111044883728, pos.f_82481_, pos.f_82479_ + (double)brick.dim, pos.f_82480_, pos.f_82481_ + (double)brick.dim);
                float[] col = Color.getHSBColor(new Random(pos.hashCode()).nextFloat(), 1.0f, 1.0f).getRGBColorComponents(null);
                DebugRenderer.m_269311_((PoseStack)poseStack, (MultiBufferSource)bufferSource, (AABB)box.m_82383_(cameraPos.m_82548_()), (float)col[0], (float)col[1], (float)col[2], (float)0.5f);
            }
        }
    }
}

