/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.compat.valkyrienskies;

import com.leclowndu93150.wakes.compat.valkyrienskies.VSUtils;
import com.leclowndu93150.wakes.compat.valkyrienskies.ValkyrienSkiesCompat;
import com.leclowndu93150.wakes.particle.custom.SplashPlaneParticle;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ShipWakeData {
    private final Ship ship;
    private Vec3 prevPosOnSurface;
    private float wakeWidth = 0.0f;
    private Vec3 offset = Vec3.f_82478_;
    private SplashPlaneParticle splashPlane;

    public ShipWakeData(Ship ship) {
        this.ship = ship;
    }

    public boolean onFluidSurface() {
        return true;
    }

    public float wakeHeight() {
        return (float)ValkyrienSkiesCompat.getSeaLevel();
    }

    public Vec3 getPrevPos() {
        return this.prevPosOnSurface == null ? null : new Vec3(this.prevPosOnSurface.f_82479_, this.prevPosOnSurface.f_82480_, this.prevPosOnSurface.f_82481_);
    }

    public void setPrevPos(Vec3 pos) {
        this.prevPosOnSurface = pos;
    }

    public Vec3 getNumericalVelocity() {
        return VectorConversionsMCKt.toMinecraft((Vector3dc)this.ship.getVelocity());
    }

    public double getHorizontalVelocity() {
        Vector3dc velocityVector = this.ship.getVelocity();
        Vector3d horizontalVelocityVector = new Vector3d(velocityVector.x(), 0.0, velocityVector.z());
        return horizontalVelocityVector.length();
    }

    public void setSplashPlane(SplashPlaneParticle particle) {
        this.splashPlane = particle;
    }

    public SplashPlaneParticle getSplashPlane() {
        return this.splashPlane;
    }

    public float getWidth() {
        return this.wakeWidth;
    }

    public void setWidth(float width) {
        this.wakeWidth = width;
    }

    public Vec3 getPos() {
        return VSUtils.getCentre(this.ship.getWorldAABB()).m_82549_(this.offset);
    }

    public void setOffset(Vector3d vec) {
        Quaterniondc mat = this.ship.getTransform().getShipToWorldRotation();
        this.offset = VectorConversionsMCKt.toMinecraft((Vector3dc)vec.rotate(mat));
    }
}

