/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.sawmill.CommonConfigs;
import net.mehvahdjukaar.sawmill.FilterableRecipe;
import net.mehvahdjukaar.sawmill.SawmillMenu;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SawmillScreen
extends AbstractContainerScreen<SawmillMenu> {
    private static final ResourceLocation BACKGROUND = SawmillMod.res("textures/gui/container/sawmill.png");
    private static final ResourceLocation BACKGROUND_SEARCH = SawmillMod.res("textures/gui/container/sawmill_search.png");
    private static final ResourceLocation BACKGROUND_WIDE = SawmillMod.res("textures/gui/container/sawmill_wide.png");
    private static final ResourceLocation BACKGROUND_WIDE_SEARCH = SawmillMod.res("textures/gui/container/sawmill_search_wide.png");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;
    private EditBox searchBox;
    private final List<FilterableRecipe> filteredRecipes = new ArrayList<FilterableRecipe>();
    private int filteredIndex = -1;

    public SawmillScreen(SawmillMenu sawmillMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)sawmillMenu, inventory, component);
        sawmillMenu.registerUpdateListener(this::containerChanged);
        --this.f_97729_;
    }

    protected void m_7856_() {
        super.m_7856_();
        int boxX = this.f_97735_ + (((SawmillMenu)this.f_97732_).isWide ? 41 : 53);
        int boxY = this.f_97736_ + 15;
        this.searchBox = new EditBox(this.f_96547_, boxX, boxY, 69, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_93692_(false);
        this.searchBox.m_94186_(false);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94151_(s -> this.refreshSearchResults());
        this.m_142416_((GuiEventListener)this.searchBox);
        this.updateSearchBarVisibility();
    }

    private void updateSearchBarVisibility() {
        boolean hasSearch;
        this.searchBox.f_93624_ = hasSearch = CommonConfigs.hasSearchBar(((SawmillMenu)this.f_97732_).getRecipes().size());
        this.searchBox.f_93623_ = hasSearch;
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.searchBox.f_93624_) {
            this.searchBox.m_94120_();
        }
    }

    private void refreshSearchResults() {
        int oldSize = this.filteredRecipes.size();
        this.filteredRecipes.clear();
        String filter = this.searchBox.m_94155_().toLowerCase(Locale.ROOT);
        boolean isFiltered = this.searchBox.f_93624_ && !filter.equals("");
        for (FilterableRecipe r : ((SawmillMenu)this.f_97732_).getRecipes()) {
            if (isFiltered && !r.matchFilter(filter)) continue;
            this.filteredRecipes.add(r);
        }
        if (oldSize != this.filteredRecipes.size()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        this.updateSelectedIndex();
        if (this.filteredIndex == -1 && ((SawmillMenu)this.f_97732_).getSelectedRecipeIndex() != -1 && ((SawmillMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, -1)) {
            this.f_96541_.f_91072_.m_105208_(((SawmillMenu)this.f_97732_).f_38840_, -1);
        }
        this.updateSearchBarVisibility();
    }

    private void updateSelectedIndex() {
        this.filteredIndex = -1;
        int selectedInd = ((SawmillMenu)this.f_97732_).getSelectedRecipeIndex();
        List<FilterableRecipe> recipes = ((SawmillMenu)this.f_97732_).getRecipes();
        if (selectedInd > -1 && selectedInd < recipes.size()) {
            this.filteredIndex = this.filteredRecipes.indexOf(recipes.get(selectedInd));
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String string = this.searchBox.m_94155_();
        this.m_6575_(minecraft, width, height);
        this.searchBox.m_94144_(string);
        this.containerChanged();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        String string = this.searchBox.m_94155_();
        if (this.searchBox.f_93624_ && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(string, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.m_93696_() && this.searchBox.m_94213_() && keyCode != 256 ? true : super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        ResourceLocation bgLocation = this.getBgLocation();
        guiGraphics.m_280218_(bgLocation, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int barH = this.scrollBarHeight();
        int scrollY = this.minScrollY();
        float barSpan = this.maxScrollY() - scrollY - barH;
        int barPos = (int)(barSpan * this.scrollOffs);
        guiGraphics.m_280218_(bgLocation, this.minScrollX(), scrollY + barPos, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, barH);
        if (!this.displayRecipes) {
            return;
        }
        this.forEachButton((index, buttonX, buttonY) -> {
            int textureY = this.f_97727_;
            if (index == this.filteredIndex) {
                textureY += 18;
            } else if (mouseX >= buttonX && mouseY >= buttonY && mouseX < buttonX + 16 && mouseY < buttonY + 18) {
                textureY += 36;
            }
            guiGraphics.m_280218_(BACKGROUND, buttonX, buttonY, 0, textureY, 16, 18);
        });
        this.forEachButton((index, buttonX, buttonY) -> {
            ItemStack item = this.filteredRecipes.get(index).recipe().m_8043_(this.f_96541_.f_91073_.m_9598_());
            guiGraphics.m_280203_(item, buttonX, buttonY + 1);
            guiGraphics.m_280370_(this.f_96547_, item, buttonX, buttonY + 1);
        });
    }

    @NotNull
    private ResourceLocation getBgLocation() {
        if (((SawmillMenu)this.f_97732_).isWide) {
            return this.searchBox.f_93624_ ? BACKGROUND_WIDE_SEARCH : BACKGROUND_WIDE;
        }
        return this.searchBox.f_93624_ ? BACKGROUND_SEARCH : BACKGROUND;
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.displayRecipes) {
            this.forEachButton((index, buttonX, buttonY) -> {
                if (mouseX >= buttonX && mouseX < buttonX + 16 && mouseY >= buttonY && mouseY < buttonY + 18) {
                    guiGraphics.m_280153_(this.f_96547_, this.filteredRecipes.get(index).recipe().m_8043_(this.f_96541_.f_91073_.m_9598_()), mouseX, mouseY);
                }
            });
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int input;
        super.m_280003_(guiGraphics, mouseX, mouseY);
        if (this.filteredIndex >= 0 && this.filteredIndex < this.filteredRecipes.size() && (input = this.filteredRecipes.get(this.filteredIndex).recipe().getInputCount()) != 1) {
            String multiplier = input + "x";
            int labelX = this.f_97728_ + (((SawmillMenu)this.f_97732_).isWide ? -4 : 0);
            guiGraphics.m_280056_(this.f_96547_, multiplier, labelX, this.f_97729_ + 37, 0x404040, false);
        }
    }

    private int getButtonCount() {
        return this.getRowCount() * this.getButtonsPerRow();
    }

    private int getButtonsPerRow() {
        return ((SawmillMenu)this.f_97732_).isWide ? 5 : 4;
    }

    private int getRowCount() {
        return this.searchBox.f_93624_ ? 2 : 3;
    }

    private int minScrollX() {
        return this.f_97735_ + (((SawmillMenu)this.f_97732_).isWide ? 123 : 119);
    }

    private int maxScrollX() {
        return this.minScrollX() + 12;
    }

    private int minScrollY() {
        return this.f_97736_ + (this.searchBox.f_93624_ ? 29 : 15);
    }

    private int maxScrollY() {
        return this.f_97736_ + (this.searchBox.f_93624_ ? 65 : 70);
    }

    private int scrollBarHeight() {
        return this.searchBox.f_93624_ ? 11 : 15;
    }

    private void forEachButton(ButtonConsumer buttonConsumer) {
        int buttonBoxX = this.f_97735_ + (((SawmillMenu)this.f_97732_).isWide ? 40 : 52);
        int buttonBoxY = this.f_97736_ + (this.searchBox.f_93624_ ? 27 : 13);
        int lastVisibleElementIndex = this.startIndex + this.getButtonCount();
        int buttonsPerRow = this.getButtonsPerRow();
        for (int index = this.startIndex; index < lastVisibleElementIndex && index < this.filteredRecipes.size(); ++index) {
            int visualIndex = index - this.startIndex;
            int buttonX = buttonBoxX + visualIndex % buttonsPerRow * 16;
            int buttonY = buttonBoxY + visualIndex / buttonsPerRow * 18 + 2;
            buttonConsumer.accept(index, buttonX, buttonY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.displayRecipes) {
            AtomicReference<Boolean> success = new AtomicReference<Boolean>(false);
            this.forEachButton((index, buttonX, buttonY) -> {
                if (((Boolean)success.get()).booleanValue()) {
                    return;
                }
                int actualIndex = ((SawmillMenu)this.f_97732_).getRecipes().indexOf(this.filteredRecipes.get(index));
                if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + 16) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + 18)) {
                    if (((SawmillMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, actualIndex)) {
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SawmillMod.SAWMILL_SELECT.get(), (float)1.0f));
                        this.f_96541_.f_91072_.m_105208_(((SawmillMenu)this.f_97732_).f_38840_, actualIndex);
                        this.updateSelectedIndex();
                    }
                    success.set(true);
                }
            });
            if (success.get().booleanValue()) {
                return true;
            }
            if (mouseX >= (double)this.minScrollX() && mouseX < (double)this.maxScrollX() && mouseY >= (double)this.minScrollY() && mouseY < (double)this.maxScrollY()) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int min = this.minScrollY();
            int max = this.maxScrollY();
            this.scrollOffs = ((float)mouseY - (float)min - 7.5f) / ((float)(max - min) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * this.getButtonsPerRow();
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isScrollBarActive()) {
            int offscreenRows = this.getOffscreenRows();
            float f = (float)delta / (float)offscreenRows;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)offscreenRows) + 0.5) * this.getButtonsPerRow();
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && this.filteredRecipes.size() > this.getButtonCount();
    }

    protected int getOffscreenRows() {
        int b = this.getButtonsPerRow();
        return (this.filteredRecipes.size() + b - 1) / b - this.getRowCount();
    }

    private void containerChanged() {
        this.displayRecipes = ((SawmillMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
            this.searchBox.m_94144_("");
        } else {
            this.m_7522_((GuiEventListener)this.searchBox);
        }
        this.searchBox.m_94186_(this.displayRecipes);
        this.searchBox.m_93692_(this.displayRecipes);
        this.refreshSearchResults();
    }

    private static interface ButtonConsumer {
        public void accept(int var1, int var2, int var3);
    }
}

