/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem;

import com.affehund.voidtotem.VoidTotem;
import com.affehund.voidtotem.client.VoidTotemCuriosRenderer;
import com.affehund.voidtotem.core.EndCityTreasureAddition;
import com.affehund.voidtotem.core.ModUtils;
import com.affehund.voidtotem.core.VoidTotemClientConfig;
import com.affehund.voidtotem.core.VoidTotemCommonConfig;
import com.affehund.voidtotem.core.VoidTotemDataGeneration;
import com.affehund.voidtotem.core.network.PacketHandler;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="voidtotem")
public class VoidTotemForge {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"voidtotem");
    public static final RegistryObject<Item> VOID_TOTEM_ITEM = ITEMS.register("totem_of_void_undying", () -> new Item(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON)));
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"voidtotem");
    public static final RegistryObject<SimpleParticleType> VOID_TOTEM_PARTICLE = PARTICLE_TYPES.register("void_totem", () -> new SimpleParticleType(true));
    private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLOBAL_LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"voidtotem");
    public static final RegistryObject<Codec<EndCityTreasureAddition>> END_CITY_TREASURE_ADDITION = GLOBAL_LOOT_MODIFIERS.register("end_city_treasure_addition", EndCityTreasureAddition.CODEC);

    public VoidTotemForge() {
        VoidTotem.init();
        if (ModUtils.isModLoaded("curios")) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        }
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addGenericListener(ItemStack.class, this::attachCaps);
        forgeEventBus.addListener(this::itemTooltip);
        forgeEventBus.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::buildContents);
        ITEMS.register(modEventBus);
        PARTICLE_TYPES.register(modEventBus);
        GLOBAL_LOOT_MODIFIERS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)VoidTotemCommonConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)VoidTotemClientConfig.SPEC);
        PacketHandler.registerMessages();
    }

    private void attachCaps(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack itemStack;
        Item item;
        if (ModUtils.isModLoaded("curios") && (item = (itemStack = (ItemStack)event.getObject()).m_41720_()).equals(VOID_TOTEM_ITEM.get())) {
            event.addCapability(new ResourceLocation("voidtotem", "curios"), new ICapabilityProvider(){
                final ICurio curio = new ICurio(){

                    public boolean canEquipFromUse(SlotContext slotContext) {
                        return true;
                    }

                    public ItemStack getStack() {
                        return itemStack;
                    }
                };

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, LazyOptional.of(() -> this.curio));
                }
            });
        }
    }

    private void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256797_) {
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42747_), (Object)new ItemStack((ItemLike)VOID_TOTEM_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        if (ModUtils.isModLoaded("curios") && ((Boolean)VoidTotemClientConfig.DISPLAY_TOTEM_ON_CHEST.get()).booleanValue()) {
            CuriosRendererRegistry.register((Item)((Item)VOID_TOTEM_ITEM.get()), VoidTotemCuriosRenderer::new);
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean isClientProvider = event.includeClient();
        boolean isServerProvider = event.includeServer();
        VoidTotemDataGeneration.BlockTagsGen blockTagsGen = new VoidTotemDataGeneration.BlockTagsGen(packOutput, lookup, existingFileHelper);
        generator.addProvider(isServerProvider, (DataProvider)new ForgeAdvancementProvider(packOutput, lookup, existingFileHelper, List.of(new VoidTotemDataGeneration.AdvancementGen())));
        generator.addProvider(isServerProvider, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(VoidTotemDataGeneration.LootTableGen::new, LootContextParamSets.f_81411_))));
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsGen);
        generator.addProvider(isServerProvider, (DataProvider)new VoidTotemDataGeneration.ItemTagsGen(packOutput, lookup, blockTagsGen, existingFileHelper));
        generator.addProvider(isServerProvider, (DataProvider)new VoidTotemDataGeneration.LootModifierGen(packOutput));
        generator.addProvider(isServerProvider, (DataProvider)new VoidTotemDataGeneration.RecipeGen(packOutput));
        generator.addProvider(isClientProvider, (DataProvider)new VoidTotemDataGeneration.LanguageGen(packOutput, "de_de"));
        generator.addProvider(isClientProvider, (DataProvider)new VoidTotemDataGeneration.LanguageGen(packOutput, "en_us"));
        generator.addProvider(isClientProvider, (DataProvider)new VoidTotemDataGeneration.ItemModelGen(packOutput, existingFileHelper));
    }

    private void itemTooltip(ItemTooltipEvent event) {
        VoidTotem.onItemTooltip(event.getItemStack(), event.getToolTip());
    }
}

