/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.umvuthana.trade;

import com.bobmowzie.mowziesmobs.server.entity.umvuthana.trade.Trade;
import com.google.common.collect.ImmutableSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class TradeStore {
    public static final TradeStore EMPTY = new TradeStore((ImmutableSet<Trade>)ImmutableSet.of(), 0);
    private final ImmutableSet<Trade> trades;
    private final int totalWeight;

    private TradeStore(ImmutableSet<Trade> trades, int totalWeight) {
        this.trades = trades;
        this.totalWeight = totalWeight;
    }

    public boolean hasStock() {
        return this.trades.size() > 0;
    }

    public Trade get(RandomSource rng) {
        if (this.totalWeight <= 0) {
            return null;
        }
        int w = rng.m_188503_(this.totalWeight);
        for (Trade t : this.trades) {
            if ((w -= t.getWeight()) >= 0) continue;
            return t;
        }
        return null;
    }

    public CompoundTag serialize() {
        CompoundTag compound = new CompoundTag();
        ListTag tradesList = new ListTag();
        for (Trade trade : this.trades) {
            tradesList.add((Object)trade.serialize());
        }
        compound.m_128365_("trades", (Tag)tradesList);
        return compound;
    }

    public static TradeStore deserialize(CompoundTag compound) {
        ListTag tradesList = compound.m_128437_("trades", 10);
        int totalWeight = 0;
        ImmutableSet.Builder trades = new ImmutableSet.Builder();
        for (int i = 0; i < tradesList.size(); ++i) {
            Trade trade = Trade.deserialize(tradesList.m_128728_(i));
            if (trade == null) continue;
            trades.add((Object)trade);
            totalWeight += trade.getWeight();
        }
        return new TradeStore((ImmutableSet<Trade>)trades.build(), totalWeight);
    }

    public static final class Builder {
        private final ImmutableSet.Builder<Trade> trades = new ImmutableSet.Builder();
        private int totalWeight;

        public Builder addTrade(Item input, int inputCount, Item output, int outputCount, int weight) {
            return this.addTrade(input, inputCount, null, output, outputCount, null, weight);
        }

        public Builder addTrade(Item input, int inputCount, CompoundTag inputMeta, Item output, int outputCount, CompoundTag outputMeta, int weight) {
            return this.addTrade(new ItemStack((ItemLike)input, inputCount, inputMeta), new ItemStack((ItemLike)output, outputCount, outputMeta), weight);
        }

        public Builder addTrade(ItemStack input, ItemStack output, int weight) {
            this.trades.add((Object)new Trade(input, output, weight));
            this.totalWeight += weight;
            return this;
        }

        public TradeStore build() {
            return new TradeStore((ImmutableSet<Trade>)this.trades.build(), this.totalWeight);
        }
    }
}

