/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.interfaces.PottablePlant;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class NeonCactusPlantBlock
extends BaseBlockNotFull
implements class_3737,
RenderLayerProvider,
PottablePlant {
    public static final class_2754<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;
    public static final class_2754<EndBlockProperties.CactusBottom> CACTUS_BOTTOM = EndBlockProperties.CACTUS_BOTTOM;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2741.field_12525;
    private static final EnumMap<class_2350, class_265> BIG_SHAPES_OPEN = Maps.newEnumMap(class_2350.class);
    private static final EnumMap<class_2350, class_265> MEDIUM_SHAPES_OPEN = Maps.newEnumMap(class_2350.class);
    private static final EnumMap<class_2350, class_265> SMALL_SHAPES_OPEN = Maps.newEnumMap(class_2350.class);
    private static final EnumMap<class_2350.class_2351, class_265> BIG_SHAPES = Maps.newEnumMap(class_2350.class_2351.class);
    private static final EnumMap<class_2350.class_2351, class_265> MEDIUM_SHAPES = Maps.newEnumMap(class_2350.class_2351.class);
    private static final EnumMap<class_2350.class_2351, class_265> SMALL_SHAPES = Maps.newEnumMap(class_2350.class_2351.class);
    private static final int MAX_LENGTH = 12;

    public NeonCactusPlantBlock() {
        super(FabricBlockSettings.copyOf((class_4970)class_2246.field_10029).lightLevel(bs -> 15).method_9640());
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11036)).method_11657(SHAPE, (Comparable)BlockProperties.TripleShape.TOP));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{SHAPE, CACTUS_BOTTOM, WATERLOGGED, FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2350 dir = ctx.method_8038();
        class_2680 down = world.method_8320(pos.method_10093(dir.method_10153()));
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(pos).method_15772() == class_3612.field_15910))).method_11657((class_2769)FACING, (Comparable)ctx.method_8038());
        state = down.method_27852(class_2246.field_10471) || down.method_27852(EndBlocks.ENDSTONE_DUST) ? (class_2680)state.method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.SAND)) : (down.method_27852(EndBlocks.END_MOSS) ? (class_2680)state.method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.MOSS)) : (class_2680)state.method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY)));
        return state;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return BlocksHelper.rotateHorizontal((class_2680)state, (class_2470)rotation, (class_2769)FACING);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return BlocksHelper.mirrorHorizontal((class_2680)state, (class_2415)mirror, (class_2769)FACING);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        class_2350 dir;
        class_2680 downState;
        world.method_39279(pos, (class_2248)this, 2);
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        state = (downState = world.method_8320(pos.method_10093((dir = (class_2350)state.method_11654((class_2769)FACING)).method_10153()))).method_27852(class_2246.field_10471) || downState.method_27852(EndBlocks.ENDSTONE_DUST) ? (class_2680)state.method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.SAND)) : (downState.method_27852(EndBlocks.END_MOSS) ? (class_2680)state.method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.MOSS)) : (class_2680)state.method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY)));
        return state;
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 random) {
        if (!blockState.method_26184((class_4538)serverLevel, blockPos)) {
            serverLevel.method_30093(blockPos, true, null, 1);
        }
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ePos) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)state.method_11654(SHAPE);
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        class_2680 next = view.method_8320(pos.method_10093(dir));
        if (next.method_27852((class_2248)this)) {
            class_2350.class_2351 axis = dir.method_10166();
            if (shape == BlockProperties.TripleShape.BOTTOM) {
                return BIG_SHAPES.get(axis);
            }
            return shape == BlockProperties.TripleShape.MIDDLE ? MEDIUM_SHAPES.get(axis) : SMALL_SHAPES.get(axis);
        }
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            return BIG_SHAPES_OPEN.get(dir);
        }
        return shape == BlockProperties.TripleShape.MIDDLE ? MEDIUM_SHAPES_OPEN.get(dir) : SMALL_SHAPES_OPEN.get(dir);
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 supportPos = pos.method_10093(dir.method_10153());
        class_2680 support = level.method_8320(supportPos);
        return support.method_27852((class_2248)this) || support.method_26206((class_1922)level, supportPos, dir);
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2350 side;
        class_2338 sidePos;
        if (!this.method_9558(state, (class_4538)world, pos) || random.method_43048(8) > 0) {
            return;
        }
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        if (!world.method_22347(pos.method_10093(dir))) {
            return;
        }
        int length = this.getLength(state, world, pos, 12);
        if (length < 0 || length > 11) {
            return;
        }
        if (dir.method_10166().method_10179()) {
            int horizontal = this.getHorizontal(state, (class_5281)world, pos, 2);
            if (horizontal > random.method_43048(2)) {
                dir = class_2350.field_11036;
                if (!world.method_8320(pos.method_10084()).method_26215()) {
                    return;
                }
            }
        } else if (length > 1 && world.method_8320(pos.method_10093(dir.method_10153())).method_27852((class_2248)this) && world.method_22347(sidePos = pos.method_10093(side = this.getSideDirection((class_5281)world, pos, state, dir, random)))) {
            class_2680 placement = (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)side);
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)sidePos, (class_2680)placement);
        }
        class_2680 placement = (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)dir);
        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos.method_10093(dir), (class_2680)placement);
        this.mutateStem(placement, (class_5281)world, pos, 12);
    }

    public void growPlant(class_5281 world, class_2338 pos, class_5819 random) {
        this.growPlant(world, pos, random, MHelper.randRange((int)6, (int)12, (class_5819)random));
    }

    public void growPlant(class_5281 world, class_2338 pos, class_5819 random, int iterations) {
        class_2680 state = this.method_9564();
        class_2680 downState = world.method_8320(pos.method_10074());
        state = downState.method_27852(class_2246.field_10471) || downState.method_27852(EndBlocks.ENDSTONE_DUST) ? (class_2680)state.method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.SAND)) : (downState.method_27852(EndBlocks.END_MOSS) ? (class_2680)state.method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.MOSS)) : (class_2680)state.method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY)));
        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)state);
        ArrayList ends = Lists.newArrayList((Object[])new class_2338.class_2339[]{pos.method_25503()});
        for (int i = 0; i < iterations; ++i) {
            int count = ends.size();
            for (int n = 0; n < count; ++n) {
                if (this.growIteration(world, (class_2338.class_2339)ends.get(n), random, ends, i)) continue;
                ends.remove(n);
                --count;
                --n;
            }
        }
    }

    private boolean growIteration(class_5281 world, class_2338.class_2339 pos, class_5819 random, List<class_2338.class_2339> ends, int length) {
        class_2350 side;
        class_2338 sidePos;
        class_2680 state = world.method_8320((class_2338)pos);
        if (!state.method_27852((class_2248)this)) {
            return false;
        }
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        if (!world.method_22347(pos.method_10093(dir))) {
            return false;
        }
        if (dir.method_10166().method_10179()) {
            int horizontal = this.getHorizontal(state, world, (class_2338)pos, 2);
            if (horizontal > random.method_43048(2)) {
                dir = class_2350.field_11036;
                if (!world.method_8320(pos.method_10084()).method_26215()) {
                    return false;
                }
            }
        } else if (length > 1 && world.method_8320(pos.method_10074()).method_27852((class_2248)this) && world.method_22347(sidePos = pos.method_10093(side = this.getSideDirection(world, (class_2338)pos, state, dir, random)))) {
            class_2680 placement = (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)side);
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)sidePos, (class_2680)placement);
            ends.add(sidePos.method_25503());
        }
        class_2680 placement = (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).method_11657(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)dir);
        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos.method_10093(dir), (class_2680)placement);
        this.mutateStem(placement, world, (class_2338)pos, 12);
        pos.method_10098(dir);
        return true;
    }

    private class_2350 getSideDirection(class_5281 world, class_2338 pos, class_2680 iterState, class_2350 dir, class_5819 random) {
        class_2350 side;
        class_2338.class_2339 iterPos = pos.method_25503();
        class_2350 startDir = dir;
        class_2350 lastDir = null;
        while (iterState.method_27852((class_2248)this) && startDir.method_10166().method_10178()) {
            startDir = (class_2350)iterState.method_11654((class_2769)FACING);
            if (lastDir == null) {
                for (class_2350 side2 : BlocksHelper.HORIZONTAL) {
                    class_2350 sideDir;
                    class_2680 sideState = world.method_8320(iterPos.method_10093(side2));
                    if (!sideState.method_27852((class_2248)this) || (sideDir = (class_2350)sideState.method_11654((class_2769)FACING)) != side2) continue;
                    lastDir = sideDir;
                }
            }
            iterPos.method_10098(dir);
            iterState = world.method_8320((class_2338)iterPos);
        }
        class_2350 class_23502 = side = lastDir == null ? BlocksHelper.randomHorizontal((class_5819)random) : lastDir.method_10170();
        if (side.method_10153() == startDir) {
            side = side.method_10153();
        }
        return side;
    }

    public boolean method_9516(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_10 pathComputationType) {
        return false;
    }

    public void method_9548(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity) {
        entity.method_5643(level.method_48963().method_48826(), 1.0f);
    }

    private int getLength(class_2680 state, class_3218 world, class_2338 pos, int max) {
        int length = 0;
        class_2350 dir = ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
        class_2338.class_2339 mut = new class_2338.class_2339().method_10101((class_2382)pos);
        for (int i = 0; i < max; ++i) {
            mut.method_10098(dir);
            state = world.method_8320((class_2338)mut);
            if (!state.method_27852((class_2248)this)) {
                if (state.method_26164(CommonBlockTags.END_STONES)) break;
                length = -1;
                break;
            }
            dir = ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
            ++length;
        }
        return length;
    }

    private int getHorizontal(class_2680 state, class_5281 world, class_2338 pos, int max) {
        int count = 0;
        class_2350 dir = ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
        class_2338.class_2339 mut = new class_2338.class_2339().method_10101((class_2382)pos);
        for (int i = 0; i < max; ++i) {
            mut.method_10098(dir);
            state = world.method_8320((class_2338)mut);
            if (!state.method_27852((class_2248)this) || (dir = ((class_2350)state.method_11654((class_2769)FACING)).method_10153()).method_10164() != 0) break;
            ++count;
        }
        return count;
    }

    private void mutateStem(class_2680 state, class_5281 world, class_2338 pos, int max) {
        class_2350 dir = ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
        class_2338.class_2339 mut = new class_2338.class_2339().method_10101((class_2382)pos);
        for (int i = 0; i < max; ++i) {
            mut.method_10098(dir);
            state = world.method_8320((class_2338)mut);
            if (!state.method_27852((class_2248)this)) {
                return;
            }
            int size = (i + 2) * 3 / max;
            int src = ((BlockProperties.TripleShape)state.method_11654(SHAPE)).getIndex();
            dir = ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
            if (src >= size) continue;
            BlockProperties.TripleShape shape = BlockProperties.TripleShape.fromIndex((int)size);
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)((class_2680)state.method_11657(SHAPE, (Comparable)shape)));
        }
    }

    @Override
    public boolean canPlantOn(class_2248 block) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public String getPottedState() {
        return "bottom=moss,shape=top,facing=up";
    }

    static {
        BIG_SHAPES.put(class_2350.class_2351.field_11048, class_2248.method_9541((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
        BIG_SHAPES.put(class_2350.class_2351.field_11052, class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        BIG_SHAPES.put(class_2350.class_2351.field_11051, class_2248.method_9541((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0));
        MEDIUM_SHAPES.put(class_2350.class_2351.field_11048, class_2248.method_9541((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES.put(class_2350.class_2351.field_11052, class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        MEDIUM_SHAPES.put(class_2350.class_2351.field_11051, class_2248.method_9541((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0));
        SMALL_SHAPES.put(class_2350.class_2351.field_11048, class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        SMALL_SHAPES.put(class_2350.class_2351.field_11052, class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        SMALL_SHAPES.put(class_2350.class_2351.field_11051, class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0));
        BIG_SHAPES_OPEN.put(class_2350.field_11036, class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(class_2350.field_11033, class_2248.method_9541((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        BIG_SHAPES_OPEN.put(class_2350.field_11043, class_2248.method_9541((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)16.0));
        BIG_SHAPES_OPEN.put(class_2350.field_11035, class_2248.method_9541((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(class_2350.field_11039, class_2248.method_9541((double)2.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(class_2350.field_11034, class_2248.method_9541((double)0.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
        MEDIUM_SHAPES_OPEN.put(class_2350.field_11036, class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(class_2350.field_11033, class_2248.method_9541((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(class_2350.field_11043, class_2248.method_9541((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)16.0));
        MEDIUM_SHAPES_OPEN.put(class_2350.field_11035, class_2248.method_9541((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(class_2350.field_11039, class_2248.method_9541((double)3.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(class_2350.field_11034, class_2248.method_9541((double)0.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
        SMALL_SHAPES_OPEN.put(class_2350.field_11036, class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(class_2350.field_11033, class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(class_2350.field_11043, class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)16.0));
        SMALL_SHAPES_OPEN.put(class_2350.field_11035, class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(class_2350.field_11039, class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(class_2350.field_11034, class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
    }
}

