/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.treasure_reforging.recipe.recipes;

import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.treasure_reforging.item.ReforgingItems;
import com.aetherteam.treasure_reforging.recipe.TreasureReforgingRecipeSerializers;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PhoenixArmorRecipe
extends CustomRecipe {
    private final Map<Item, Item> conversions = new HashMap<Item, Item>(Map.of((Item)AetherItems.OBSIDIAN_BOOTS.get(), (Item)AetherItems.PHOENIX_BOOTS.get(), (Item)AetherItems.OBSIDIAN_LEGGINGS.get(), (Item)AetherItems.PHOENIX_LEGGINGS.get(), (Item)AetherItems.OBSIDIAN_CHESTPLATE.get(), (Item)AetherItems.PHOENIX_CHESTPLATE.get(), (Item)AetherItems.OBSIDIAN_HELMET.get(), (Item)AetherItems.PHOENIX_HELMET.get(), (Item)AetherItems.OBSIDIAN_GLOVES.get(), (Item)AetherItems.PHOENIX_GLOVES.get()));
    private static final Ingredient SHARD_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ReforgingItems.PYRAL_SHARD.get()});

    public PhoenixArmorRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        int shardCount = 0;
        int equipmentCount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (item.m_41619_()) continue;
            if (this.conversions.containsKey(item.m_41720_())) {
                ++equipmentCount;
                continue;
            }
            if (!SHARD_INGREDIENT.test(item)) continue;
            ++shardCount;
        }
        return shardCount == 4 && equipmentCount == 1;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack result = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (item.m_41619_() || !this.conversions.containsKey(item.m_41720_())) continue;
            result = new ItemStack((ItemLike)this.conversions.get(item.m_41720_()));
            EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)item), (ItemStack)result);
            if (!item.m_41782_()) continue;
            result.m_41751_(item.m_41783_());
        }
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TreasureReforgingRecipeSerializers.PHOENIX_ARMOR.get();
    }
}

