/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.treasure_reforging.block;

import com.aetherteam.aether.block.miscellaneous.FacingPillarBlock;
import com.aetherteam.treasure_reforging.item.ReforgingItems;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ReforgingBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"aether_treasure_reforging");
    public static final RegistryObject<FacingPillarBlock> VALKYRUM_BLOCK = ReforgingBlocks.register("valkyrum_block", () -> new FacingPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280658_(NoteBlockInstrument.CHIME).m_60913_(5.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> PYRAL_BLOCK = ReforgingBlocks.register("pyral_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_280658_(NoteBlockInstrument.DIDGERIDOO).m_60913_(5.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56743_)));

    private static <T extends Block> RegistryObject<T> baseRegister(String name, Supplier<? extends T> block, Function<RegistryObject<T>, Supplier<? extends Item>> item) {
        RegistryObject register = BLOCKS.register(name, block);
        ReforgingItems.ITEMS.register(name, item.apply(register));
        return register;
    }

    private static <B extends Block> RegistryObject<B> register(String name, Supplier<? extends Block> block) {
        return ReforgingBlocks.baseRegister(name, block, ReforgingBlocks::registerBlockItem);
    }

    private static <B extends Block> Supplier<BlockItem> registerBlockItem(RegistryObject<B> blockRegistryObject) {
        return () -> {
            Block block = Objects.requireNonNull((Block)blockRegistryObject.get());
            if (block == PYRAL_BLOCK.get()) {
                return new BlockItem(block, new Item.Properties().m_41486_());
            }
            return new BlockItem(block, new Item.Properties());
        };
    }
}

