/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.repackage.io.github.queerbric.pride;

import com.unascribed.fabrication.repackage.io.github.queerbric.pride.PrideFlag;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.Nullable;

public class PrideFlags {
    private static List<PrideFlag> flags = new ArrayList<PrideFlag>();
    private static Map<String, PrideFlag> flagsById = new HashMap<String, PrideFlag>();
    private static Random defaultRandom = new Random();
    private static final boolean PRIDE_MONTH = Calendar.getInstance(Locale.ENGLISH).get(2) == 5 || Boolean.getBoolean("everyMonthIsPrideMonth");

    protected static void setFlags(List<PrideFlag> flags) {
        PrideFlags.flags = Collections.unmodifiableList(flags);
        HashMap<String, PrideFlag> bldr = new HashMap<String, PrideFlag>(flags.size());
        for (PrideFlag flag : flags) {
            bldr.put(flag.getId(), flag);
        }
        flagsById = Collections.unmodifiableMap(bldr);
    }

    public static List<PrideFlag> getFlags() {
        return flags;
    }

    @Nullable
    public static PrideFlag getFlag(String id) {
        return flagsById.get(id);
    }

    @Nullable
    public static PrideFlag getRandomFlag(Random random) {
        if (flags.isEmpty()) {
            return null;
        }
        return flags.get(random.nextInt(flags.size()));
    }

    @Nullable
    public static PrideFlag getRandomFlag() {
        return PrideFlags.getRandomFlag(defaultRandom);
    }

    public static boolean isPrideMonth() {
        return PRIDE_MONTH;
    }
}

