/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.g_weird_tweaks.source_dependent_iframes;

import com.google.common.collect.ImmutableList;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.interfaces.TickSourceIFrames;
import com.unascribed.fabrication.support.ConfigPredicates;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@EligibleIf(configAvailable="*.source_dependent_iframes")
@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity
implements TickSourceIFrames {
    private final LinkedHashMap<String, Integer> fabrication$iframeTracker = new LinkedHashMap();
    private int fabrication$timeUntilRegen = 0;
    private static final Predicate<List<?>> fabrication$sourceDependentIframesPredicate = ConfigPredicates.getFinalPredicate("*.source_dependent_iframes");

    public MixinLivingEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    @FabInject(at={@At(value="HEAD")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"})
    private void checkDependentIFrames(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!FabConf.isEnabled("*.source_dependent_iframes") || !fabrication$sourceDependentIframesPredicate.test((List<?>)ImmutableList.of((Object)this, (Object)source))) {
            return;
        }
        String origin = source.m_19385_() + (source.m_7639_() == null || source.m_7639_().m_20148_() == null ? ":direct" : source.m_7639_().m_20148_().toString());
        if (this.fabrication$iframeTracker.containsKey(origin)) {
            this.f_19802_ = 20;
        } else {
            this.fabrication$iframeTracker.put(origin, this.f_19797_ + 9);
            this.f_19802_ = 0;
        }
    }

    @FabInject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"})
    private void setSourceDependentIFrames(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!FabConf.isEnabled("*.source_dependent_iframes") || !fabrication$sourceDependentIframesPredicate.test((List<?>)ImmutableList.of((Object)this, (Object)source))) {
            return;
        }
        if (this.fabrication$timeUntilRegen == 0) {
            this.fabrication$timeUntilRegen = 10;
        }
    }

    @FabInject(at={@At(value="HEAD")}, method={"baseTick()V"})
    private void tickSourceDependentIFrames(CallbackInfo ci) {
        if (!FabConf.isEnabled("*.source_dependent_iframes") || this instanceof ServerPlayer) {
            return;
        }
        this.fabrication$tickSourceDependentIFrames();
    }

    @Override
    public void fabrication$tickSourceDependentIFrames() {
        if (this.fabrication$timeUntilRegen > 0) {
            --this.fabrication$timeUntilRegen;
        } else if (!this.fabrication$iframeTracker.isEmpty()) {
            Iterator<Integer> iter = this.fabrication$iframeTracker.values().iterator();
            iter.next();
            iter.remove();
            while (iter.hasNext()) {
                int t = iter.next() - this.f_19797_;
                if (t > 0) {
                    this.fabrication$timeUntilRegen = t;
                    continue;
                }
                iter.remove();
            }
        }
    }
}

