/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.f_balance.hunger_is;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.support.ConfigPredicates;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.ModifyReturn;
import java.util.function.Predicate;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;

@EligibleIf(anyConfigAvailable={"*.hunger_is_peaceful", "*.hunger_is_easy", "*.hunger_is_normal", "*.hunger_is_hard"})
@Mixin(value={FoodData.class})
public class MixinHungerManager {
    private static final Predicate<Player> fabrication$hungerPeaceful = ConfigPredicates.getFinalPredicate("*.hunger_is_peaceful");
    private static final Predicate<Player> fabrication$hungerEasy = ConfigPredicates.getFinalPredicate("*.hunger_is_easy");
    private static final Predicate<Player> fabrication$hungerNormal = ConfigPredicates.getFinalPredicate("*.hunger_is_normal");
    private static final Predicate<Player> fabrication$hungerHard = ConfigPredicates.getFinalPredicate("*.hunger_is_hard");

    @ModifyReturn(method={"update(Lnet/minecraft/entity/player/PlayerEntity;)V"}, target={"Lnet/minecraft/world/World;getDifficulty()Lnet/minecraft/world/Difficulty;"})
    private static Difficulty fabrication$pacefullHunger(Difficulty dif, Level world, FoodData hungerManager, Player pe) {
        if (FabConf.isEnabled("*.hunger_is_hard") && fabrication$hungerHard.test(pe)) {
            return Difficulty.HARD;
        }
        if (FabConf.isEnabled("*.hunger_is_normal") && fabrication$hungerNormal.test(pe)) {
            return Difficulty.NORMAL;
        }
        if (FabConf.isEnabled("*.hunger_is_easy") && fabrication$hungerEasy.test(pe)) {
            return Difficulty.EASY;
        }
        if (FabConf.isEnabled("*.hunger_is_peaceful") && fabrication$hungerPeaceful.test(pe)) {
            return Difficulty.PEACEFUL;
        }
        return dif;
    }
}

