/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.f_balance.broken_tools_drop_components;

import com.google.common.collect.Lists;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.loaders.LoaderGearComponents;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import com.unascribed.fabrication.util.Resolvable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@EligibleIf(configAvailable="*.broken_tools_drop_components")
@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    public MixinLivingEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    @FabInject(at={@At(value="HEAD")}, method={"sendEquipmentBreakStatus(Lnet/minecraft/entity/EquipmentSlot;)V"})
    public void sendEquipmentBreakStatus(EquipmentSlot slot, CallbackInfo ci) {
        this.shatter(slot, ((LivingEntity)this).m_6844_(slot));
    }

    @FabInject(at={@At(value="HEAD")}, method={"sendToolBreakStatus(Lnet/minecraft/util/Hand;)V"})
    public void sendToolBreakStatus(InteractionHand hand, CallbackInfo ci) {
        this.shatter(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, ((LivingEntity)this).m_21120_(hand));
    }

    @Unique
    private void shatter(EquipmentSlot slot, ItemStack stack) {
        if (!FabConf.isEnabled("*.broken_tools_drop_components")) {
            return;
        }
        Item item = stack.m_41720_();
        if (LoaderGearComponents.ignoreVanishing && EnchantmentHelper.m_44924_((ItemStack)stack)) {
            return;
        }
        if (stack.m_41782_() && stack.m_41783_().m_128471_("fabrication:ShatteredAlready")) {
            return;
        }
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128379_("fabrication:ShatteredAlready", true);
        ArrayList enchantables = Lists.newArrayList();
        for (LoaderGearComponents.ItemMaterialValue itemMaterialValue : LoaderGearComponents.items.get(Resolvable.mapKey(BuiltInRegistries.f_257033_.m_7981_((Object)item), BuiltInRegistries.f_257033_))) {
            int i;
            double dropRate;
            double dropChance = 1.0;
            MixinLivingEntity self = this;
            if (self instanceof Mob) {
                dropChance = FabRefl.MobEntity_getDropChance((Mob)self, slot);
                if (dropChance > 1.0) {
                    dropChance = 1.0;
                }
                if (dropChance <= 0.0) continue;
            }
            double d = dropRate = itemMaterialValue.ignoreDropRate ? 1.0 : LoaderGearComponents.dropRate.getAsDouble();
            if (itemMaterialValue.materialName.equals("xp")) {
                int thisOrb;
                Vec3 c = this.m_20191_().m_82399_();
                for (int xpAmt = (int)Math.round(itemMaterialValue.valueInIngots * (dropRate * dropChance)); xpAmt > 0; xpAmt -= thisOrb) {
                    thisOrb = ExperienceOrb.m_20782_((int)xpAmt);
                    this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), c.f_82479_, c.f_82480_, c.f_82481_, thisOrb));
                }
                continue;
            }
            LoaderGearComponents.MaterialData md = LoaderGearComponents.materials.get(itemMaterialValue.materialName);
            if (md == null) continue;
            Item ingot = md.ingotGetter.get();
            Item nugget = md.nuggetGetter.get();
            int nuggetsPerIngot = md.nuggetsPerIngot;
            double value = itemMaterialValue.valueInIngots;
            int valueInNuggets = (int)(value * (double)nuggetsPerIngot);
            int nuggetsToReturn = (int)((double)valueInNuggets * (dropRate * dropChance));
            if (!itemMaterialValue.ignoreDropRate) {
                nuggetsToReturn -= LoaderGearComponents.cheat;
            }
            if (nuggetsToReturn <= 0) continue;
            if (ingot != null) {
                int guaranteed = LoaderGearComponents.guaranteedIngots;
                int maxIngotsToReturn = nuggetsToReturn / nuggetsPerIngot;
                int ingotsToReturn = maxIngotsToReturn <= 0 ? 0 : (guaranteed >= maxIngotsToReturn ? maxIngotsToReturn : this.m_9236_().f_46441_.m_188503_(maxIngotsToReturn + 1 - guaranteed) + guaranteed);
                nuggetsToReturn -= ingotsToReturn * nuggetsPerIngot;
                if (itemMaterialValue.enchant && stack.m_41793_()) {
                    for (i = 0; i < ingotsToReturn; ++i) {
                        enchantables.add(new ItemStack((ItemLike)ingot));
                    }
                } else {
                    for (i = 0; i < ingotsToReturn; ++i) {
                        this.m_19998_((ItemLike)ingot);
                    }
                }
            }
            if (nugget == null) continue;
            if (itemMaterialValue.enchant && stack.m_41793_()) {
                for (i = 0; i < nuggetsToReturn; ++i) {
                    enchantables.add(new ItemStack((ItemLike)nugget));
                }
                continue;
            }
            for (i = 0; i < nuggetsToReturn; ++i) {
                this.m_19998_((ItemLike)nugget);
            }
        }
        if (enchantables.size() == 1) {
            EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)stack), (ItemStack)((ItemStack)enchantables.get(0)));
        } else if (!enchantables.isEmpty()) {
            for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
                int lvl = (Integer)entry.getValue();
                int[] values = lvl == 1 || this.m_9236_().f_46441_.m_188503_(3) == 0 ? new int[]{lvl} : (lvl == 2 ? new int[]{1, 1} : (lvl >= 4 && enchantables.size() >= 4 && this.m_9236_().f_46441_.m_188499_() ? new int[]{lvl - 1, lvl - 2, lvl - 3, lvl - 3} : (enchantables.size() >= 3 && this.m_9236_().f_46441_.m_188499_() ? new int[]{lvl - 1, lvl - 2, lvl - 2} : new int[]{lvl - 1, lvl - 1})));
                if (values.length == 1) {
                    ((ItemStack)enchantables.get(this.m_9236_().f_46441_.m_188503_(enchantables.size()))).m_41663_((Enchantment)entry.getKey(), values[0]);
                    continue;
                }
                Collections.shuffle(enchantables);
                for (int i = 0; i < values.length; ++i) {
                    ((ItemStack)enchantables.get(i)).m_41663_((Enchantment)entry.getKey(), values[i]);
                }
            }
        }
        for (ItemStack itemStack : enchantables) {
            this.m_19983_(itemStack);
        }
    }
}

