/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.c_tweaks.no_hunger;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.interfaces.NoHungerAdd;
import com.unascribed.fabrication.support.ConfigPredicates;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import java.util.function.Predicate;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@EligibleIf(configAvailable="*.no_hunger")
@Mixin(value={FoodData.class}, priority=200)
public abstract class MixinHungerManager
implements NoHungerAdd {
    @Unique
    private float fabrication$noHungerHeal = 0.0f;
    @Shadow
    private float f_38697_;
    @Shadow
    private int f_38696_;
    private static final Predicate<Player> fabrication$noHungerPredicate = ConfigPredicates.getFinalPredicate("*.no_hunger");

    @FabInject(at={@At(value="HEAD")}, method={"eat(Lnet/minecraft/item/Item;Lnet/minecraft/item/ItemStack;)V"}, cancellable=true)
    public void eatFood(Item item, ItemStack stack, CallbackInfo ci) {
        if (!FabConf.isEnabled("*.no_hunger")) {
            return;
        }
        if (item.m_41472_()) {
            FoodProperties food = item.m_41473_();
            if (food == null) {
                return;
            }
            this.setFabrication$noHungerHeal(food.m_38744_(), food.m_38745_());
        }
    }

    @Override
    @Unique
    public void setFabrication$noHungerHeal(int food, float sat) {
        float f;
        sat = ((float)food + sat) * 0.75f;
        this.fabrication$noHungerHeal += f < 1.0f ? sat * 0.5f : (float)((int)sat);
    }

    @FabInject(at={@At(value="HEAD")}, method={"update(Lnet/minecraft/entity/player/PlayerEntity;)V"}, cancellable=true)
    public void update(Player pe, CallbackInfo ci) {
        if (!FabConf.isEnabled("*.no_hunger")) {
            return;
        }
        if (!fabrication$noHungerPredicate.test(pe)) {
            this.fabrication$noHungerHeal = 0.0f;
            return;
        }
        if (this.fabrication$noHungerHeal != 0.0f) {
            pe.m_5634_(this.fabrication$noHungerHeal);
            this.fabrication$noHungerHeal = 0.0f;
        }
        this.f_38696_ = pe.m_21023_(MobEffects.f_19612_) ? 0 : (pe.m_21223_() >= pe.m_21233_() ? 20 : 17);
        this.f_38697_ = 10.0f;
        if (!pe.m_21023_(MobEffects.f_19612_)) {
            ci.cancel();
        }
    }
}

