/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.a_fixes.fix_nether_portal_nausea;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.interfaces.PortalRenderFix;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.injection.FabInject;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@EligibleIf(configAvailable="*.fix_nether_portal_nausea", envMatches=Env.CLIENT)
@Mixin(value={LocalPlayer.class})
public abstract class MixinClientPlayerEntity
extends Player
implements PortalRenderFix {
    private float fabrication$lastClientPortalTicks;
    private float fabrication$nextClientPortalTicks;

    public MixinClientPlayerEntity(EntityType yaw, Level gameProfile) {
        MixinClientPlayerEntity mixinClientPlayerEntity = this;
        float f = world;
        super(yaw, gameProfile);
        this.fabrication$lastClientPortalTicks = 0.0f;
        this.fabrication$nextClientPortalTicks = 0.0f;
    }

    @FabInject(method={"tickMovement()V"}, at={@At(value="HEAD")})
    private void fixPortalNausea(CallbackInfo ci) {
        if (!FabConf.isEnabled("*.fix_nether_portal_nausea")) {
            return;
        }
        this.fabrication$lastClientPortalTicks = this.fabrication$nextClientPortalTicks;
        if (this.f_19817_) {
            if (this.fabrication$nextClientPortalTicks < 1.0f) {
                this.fabrication$nextClientPortalTicks += 0.0125f;
            } else if (this.fabrication$nextClientPortalTicks >= 1.0f) {
                this.fabrication$nextClientPortalTicks = 1.0f;
            }
        } else {
            if (this.fabrication$nextClientPortalTicks > 0.0f) {
                this.fabrication$nextClientPortalTicks -= 0.05f;
            }
            if (this.fabrication$nextClientPortalTicks < 0.0f) {
                this.fabrication$nextClientPortalTicks = 0.0f;
            }
        }
    }

    @Override
    public boolean fabrication$shouldRenderPortal() {
        return this.fabrication$nextClientPortalTicks > 0.0f && this.fabrication$lastClientPortalTicks > 0.0f && this.m_21023_(MobEffects.f_19604_);
    }

    @Override
    public float fabrication$getPortalRenderProgress(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.fabrication$lastClientPortalTicks, (float)this.fabrication$nextClientPortalTicks);
    }
}

