/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.mojang.blaze3d.platform.NativeImage;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.client.SpriteLava;
import com.unascribed.fabrication.client.SpriteLavaFlow;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;

@EligibleIf(anyConfigAvailable={"*.old_lava", "*.old_lava_scaling"}, envMatches=Env.CLIENT)
public class FeatureOldLava
implements Feature {
    public static void onLoaded(TextureAtlas atlas, SpriteLoader.Preparations data) {
        try {
            if (FabConf.isAnyEnabled("*.old_lava") && atlas.m_118330_().toString().equals("minecraft:textures/atlas/blocks.png")) {
                int lavaFlowHeight;
                int lavaFlowWidth;
                int lavaHeight;
                int lavaWidth;
                ResourceLocation still = new ResourceLocation("block/lava_still");
                ResourceLocation flow = new ResourceLocation("block/lava_flow");
                TextureAtlasSprite originalLava = atlas.m_118316_(still);
                TextureAtlasSprite originalLavaFlow = atlas.m_118316_(flow);
                if (FabConf.isEnabled("*.old_lava_scaling")) {
                    lavaWidth = originalLava.m_245424_().m_246492_();
                    lavaHeight = originalLava.m_245424_().m_245330_();
                    lavaFlowWidth = originalLavaFlow.m_245424_().m_246492_();
                    lavaFlowHeight = originalLavaFlow.m_245424_().m_245330_();
                } else {
                    lavaHeight = 16;
                    lavaWidth = 16;
                    lavaFlowHeight = 32;
                    lavaFlowWidth = 32;
                }
                NativeImage image = new NativeImage(lavaWidth, lavaHeight, false);
                SpriteLava newLava = new SpriteLava(atlas.m_118330_(), new SpriteContents(still, new FrameSize(lavaWidth, lavaHeight), image, AnimationMetadataSection.f_119012_), data.f_243669_(), data.f_244632_(), FabRefl.Client.getX(originalLava), FabRefl.Client.getY(originalLava), image);
                image = new NativeImage(lavaFlowWidth, lavaFlowHeight, false);
                SpriteLavaFlow newLavaFlow = new SpriteLavaFlow(atlas.m_118330_(), new SpriteContents(flow, new FrameSize(lavaFlowWidth, lavaFlowHeight), image, AnimationMetadataSection.f_119012_), data.f_243669_(), data.f_244632_(), FabRefl.Client.getX(originalLavaFlow), FabRefl.Client.getY(originalLavaFlow), image);
                HashMap<ResourceLocation, TextureAtlasSprite> map = new HashMap<ResourceLocation, TextureAtlasSprite>(FabRefl.Client.getSprites(atlas));
                map.put(still, newLava);
                map.put(flow, newLavaFlow);
                FabRefl.Client.setSprites(atlas, map);
                ArrayList<TextureAtlasSprite.Ticker> animatedSprites = new ArrayList<TextureAtlasSprite.Ticker>(FabRefl.Client.getAnimatedSprites(atlas));
                animatedSprites.add(newLava);
                animatedSprites.add(newLavaFlow);
                FabRefl.Client.setAnimatedSprites(atlas, animatedSprites);
                for (int i = 0; i < 100; ++i) {
                    newLava.tickAnimation();
                    newLavaFlow.tickAnimation();
                }
                newLavaFlow.m_245385_();
                newLava.m_245385_();
            }
        }
        catch (Throwable t) {
            FabricationMod.featureError(FeatureOldLava.class, "*.old_lava", t, "Unknown");
        }
    }

    @Override
    public void apply() {
        if (Minecraft.m_91087_().m_91098_() != null) {
            Minecraft.m_91087_().m_91391_();
        }
    }

    @Override
    public boolean undo() {
        this.apply();
        return true;
    }

    @Override
    public String getConfigKey() {
        return "*.old_lava";
    }

    public static void mip(NativeImage[] images) {
        if (images.length <= 1) {
            return;
        }
        for (int i = 1; i <= images.length - 1; ++i) {
            NativeImage src = images[i - 1];
            NativeImage mip = images[i];
            int w = mip.m_84982_();
            int h = mip.m_85084_();
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    mip.m_84988_(x, y, FabRefl.Client.MipmapHelper_blend(src.m_84985_(x * 2 + 0, y * 2 + 0), src.m_84985_(x * 2 + 1, y * 2 + 0), src.m_84985_(x * 2 + 0, y * 2 + 1), src.m_84985_(x * 2 + 1, y * 2 + 1), false));
                }
            }
        }
    }
}

