/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Feature;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

@EligibleIf(configAvailable="*.i_and_more")
public class FeatureIMore
implements Feature {
    private boolean applied = false;
    private boolean registered = false;

    @Override
    public void apply() {
        this.applied = true;
        if (!this.registered) {
            this.registered = true;
            Agnos.runForCommandRegistration((dispatcher, registryAccess, dedi) -> {
                String[] itemCommandNames;
                Predicate<CommandSourceStack> requirement = s -> s.m_6761_(2) && FabConf.isEnabled("*.i_and_more") && this.applied;
                for (String name : itemCommandNames = new String[]{"item", "i"}) {
                    dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)name).requires(requirement)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)registryAccess)).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::item))).executes(this::item)));
                }
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"more").requires(requirement)).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> this.more((CommandContext<CommandSourceStack>)c, EquipmentSlot.MAINHAND)))).then(Commands.m_82127_((String)"main").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> this.more((CommandContext<CommandSourceStack>)c, EquipmentSlot.MAINHAND))))).then(Commands.m_82127_((String)"off").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> this.more((CommandContext<CommandSourceStack>)c, EquipmentSlot.OFFHAND))))).then(Commands.m_82127_((String)"both").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> {
                    this.more((CommandContext<CommandSourceStack>)c, EquipmentSlot.OFFHAND);
                    return this.more((CommandContext<CommandSourceStack>)c, EquipmentSlot.MAINHAND);
                })))).executes(c -> this.more((CommandContext<CommandSourceStack>)c, EquipmentSlot.MAINHAND)));
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fenchant").requires(requirement)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enchantment", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registryAccess, (ResourceKey)Registries.f_256762_)).executes(ctx -> this.fenchant((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), (Enchantment)ResourceArgument.m_245369_((CommandContext)ctx, (String)"enchantment").m_203334_(), 1))).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> this.fenchant((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), (Enchantment)ResourceArgument.m_245369_((CommandContext)ctx, (String)"enchantment").m_203334_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level")))))));
            });
        }
    }

    public int fenchant(CommandSourceStack source, Collection<? extends Entity> targets, Enchantment enchantment, int level) throws CommandSyntaxException {
        int amt = 0;
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                ItemStack stack = le.m_21205_();
                if (!stack.m_41619_()) {
                    CompoundTag tag = stack.m_41784_();
                    if (!tag.m_128425_("Enchantments", 9)) {
                        tag.m_128365_("Enchantments", (Tag)new ListTag());
                    }
                    ListTag ench = tag.m_128437_("Enchantments", 10);
                    CompoundTag c = new CompoundTag();
                    c.m_128359_("id", String.valueOf(BuiltInRegistries.f_256876_.m_7981_((Object)enchantment)));
                    c.m_128405_("lvl", level);
                    ench.add((Object)c);
                    ++amt;
                    continue;
                }
                if (targets.size() != 1) continue;
                throw new CommandRuntimeException((Component)Component.m_237110_((String)"commands.enchant.failed.itemless", (Object[])new Object[]{le.m_7755_()}));
            }
            if (targets.size() != 1) continue;
            throw new CommandRuntimeException((Component)Component.m_237110_((String)"commands.enchant.failed.entity", (Object[])new Object[]{entity.m_7755_()}));
        }
        if (amt == 0) {
            throw new CommandRuntimeException((Component)Component.m_237115_((String)"commands.enchant.failed"));
        }
        if (targets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.enchant.success.single", (Object[])new Object[]{enchantment.m_44700_(level), ((Entity)targets.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.enchant.success.multiple", (Object[])new Object[]{enchantment.m_44700_(level), targets.size()}), true);
        }
        return amt;
    }

    public int more(CommandContext<CommandSourceStack> ctx, EquipmentSlot slot) throws CommandSyntaxException {
        int count;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack held = player.m_6844_(slot);
        if (held.m_41619_()) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"Cannot duplicate an empty stack"));
        }
        try {
            count = (Integer)ctx.getArgument("count", Integer.class);
            if (count > held.m_41741_()) {
                throw new CommandRuntimeException((Component)Component.m_237110_((String)"arguments.item.overstacked", (Object[])new Object[]{held.m_41786_(), held.m_41741_()}));
            }
        }
        catch (IllegalArgumentException e) {
            count = held.m_41741_();
        }
        if (held.m_41613_() == count) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"Your stack is already that large"));
        }
        if (held.m_41613_() > count) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"Your stack is already bigger than that"));
        }
        int amt = count - held.m_41613_();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{amt, held.m_41611_(), player.m_5446_()}), true);
        held.m_41764_(count);
        player.m_8061_(slot, held);
        return 1;
    }

    public int item(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int count;
        try {
            count = (Integer)ctx.getArgument("count", Integer.class);
        }
        catch (IllegalArgumentException e) {
            count = 1;
        }
        return FabRefl.GiveCommand_execute((CommandSourceStack)ctx.getSource(), (ItemInput)ctx.getArgument("item", ItemInput.class), Collections.singleton(((CommandSourceStack)ctx.getSource()).m_81375_()), count);
    }

    @Override
    public boolean undo() {
        this.applied = false;
        return true;
    }

    @Override
    public String getConfigKey() {
        return "*.i_and_more";
    }
}

