/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Sets;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.loaders.LoaderDimensionalTools;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.Feature;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.locale.Language;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@EligibleIf(configAvailable="*.dimensional_tools")
public class FeatureDimensionalTools
implements Feature {
    private static final NumberFormat format = NumberFormat.getNumberInstance();
    private boolean applied = false;
    private boolean active = false;

    @Override
    public void apply() {
        this.active = true;
        if (!this.applied) {
            this.applied = true;
            if (EarlyAgnos.getCurrentEnv() == Env.CLIENT) {
                this.applyClient();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void applyClient() {
        Agnos.runForTooltipRender((stack, lines) -> {
            if (this.active && !stack.m_41619_() && stack.m_41782_() && stack.m_41783_().m_128441_("fabrication:PartialDamage")) {
                for (int i = 0; i < lines.size(); ++i) {
                    Object t = lines.get(i);
                    double part = stack.m_41783_().m_128459_("fabrication:PartialDamage");
                    if (!(t instanceof MutableComponent) || !(((MutableComponent)t).m_214077_() instanceof TranslatableContents) || !((TranslatableContents)((MutableComponent)t).m_214077_()).m_237508_().equals("item.durability")) continue;
                    lines.set(i, Component.m_237110_((String)"item.durability", (Object[])new Object[]{format.format((double)(stack.m_41776_() - stack.m_41773_()) + (1.0 - part)), stack.m_41776_()}));
                }
            }
        });
    }

    @Override
    public boolean undo() {
        this.active = false;
        return true;
    }

    @Override
    public String getConfigKey() {
        return "*.dimensional_tools";
    }

    public static void handleCraft(CraftingContainer inv, ItemStack stack) {
        if (LoaderDimensionalTools.isSubstitutable(stack.m_41720_())) {
            int count = 0;
            HashMultiset dimensions = null;
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack ing = inv.m_8020_(i);
                if (ing.m_41619_()) continue;
                Set<LoaderDimensionalTools.MohsIdentifier> assoc = LoaderDimensionalTools.getAssociatedDimensionsForIngredient(ing);
                if (assoc.isEmpty()) {
                    return;
                }
                if (assoc.contains(null)) continue;
                ++count;
                if (dimensions == null) {
                    dimensions = HashMultiset.create();
                }
                dimensions.addAll(assoc);
            }
            if (dimensions != null) {
                HashSet finalDimensions = Sets.newHashSet();
                for (Object en : dimensions.entrySet()) {
                    if (en.getCount() != count) continue;
                    finalDimensions.add((LoaderDimensionalTools.MohsIdentifier)en.getElement());
                }
                if (!finalDimensions.isEmpty()) {
                    String s = Language.m_128107_().m_6834_(stack.m_41778_());
                    for (LoaderDimensionalTools.NameSubstitution sub : LoaderDimensionalTools.nameSubstitutions) {
                        if (!finalDimensions.contains(new LoaderDimensionalTools.MohsIdentifier(true, sub.dimId)) && !finalDimensions.contains(new LoaderDimensionalTools.MohsIdentifier(false, sub.dimId))) continue;
                        s = s.replace(sub.find, sub.replace);
                    }
                    stack.m_41714_((Component)Component.m_237113_((String)("\u00a7f" + s)));
                    ListTag li = new ListTag();
                    for (LoaderDimensionalTools.MohsIdentifier dim : finalDimensions) {
                        li.add((Object)StringTag.m_129297_((String)dim.toString()));
                    }
                    stack.m_41783_().m_128365_("fabrication:HonoraryDimensions", (Tag)li);
                }
            }
        }
    }

    static {
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(2);
    }
}

