/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FabricationResourcePack
implements PackResources {
    private final String path;
    private final JsonObject meta;

    public FabricationResourcePack(String path) {
        JsonObject meta;
        this.path = path;
        try {
            meta = (JsonObject)new Gson().fromJson(Resources.toString((URL)this.url("pack.mcmeta"), (Charset)Charsets.UTF_8), JsonObject.class);
        }
        catch (Throwable t) {
            FabLog.warn("Failed to load meta for internal resource pack " + path);
            meta = new JsonObject();
        }
        this.meta = meta;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IoSupplier<InputStream> m_8017_(String ... seg) {
        if (seg.length == 0) {
            return null;
        }
        if ("pack.png".equals(seg[0])) {
            return new IoSupplier<InputStream>(){

                public InputStream m_247737_() {
                    return this.getClass().getClassLoader().getResourceAsStream("assets/fabrication/icon.png");
                }
            };
        }
        final InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.path + "/" + String.join((CharSequence)"/", seg));
        if (is == null) {
            return null;
        }
        return new IoSupplier<InputStream>(){

            public InputStream m_247737_() {
                return is;
            }
        };
    }

    private URL url(PackType type, ResourceLocation id) {
        return this.url(type.m_10305_() + "/" + id.m_135827_() + "/" + id.m_135815_());
    }

    private URL url(String path) {
        return this.getClass().getClassLoader().getResource("packs/" + this.path + "/" + path);
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation id) {
        final URL u = this.url(type, id);
        if (u == null) {
            return null;
        }
        return new IoSupplier<InputStream>(){

            public InputStream m_247737_() throws IOException {
                return u.openStream();
            }
        };
    }

    public void m_8031_(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        String prePath = "packs/" + this.path + "/" + type.m_10305_() + "/" + namespace + "/";
        String dirPathStr = prePath + prefix;
        try {
            URL dirUrl = this.getClass().getClassLoader().getResource(dirPathStr);
            if (dirUrl == null) {
                return;
            }
            if ("jar".equals(dirUrl.getProtocol())) {
                JarFile jar = ((JarURLConnection)dirUrl.openConnection()).getJarFile();
                Enumeration<JarEntry> en = jar.entries();
                while (en.hasMoreElements()) {
                    String name = en.nextElement().getName();
                    int i = name.indexOf(dirPathStr);
                    if (i == -1) continue;
                    ResourceLocation id = new ResourceLocation("fabrication", name.substring(i + prePath.length()));
                    consumer.accept((Object)id, this.m_214146_(type, id));
                }
            } else {
                ArrayList<File> dirs = new ArrayList<File>();
                dirs.add(new File(dirUrl.getFile()));
                for (int i = 0; i < dirs.size(); ++i) {
                    File[] files = ((File)dirs.get(i)).listFiles();
                    if (files == null) continue;
                    for (File file : files) {
                        if (file.isDirectory()) {
                            dirs.add(file);
                            continue;
                        }
                        String name = file.getPath();
                        int ix = name.indexOf(dirPathStr);
                        if (ix == -1) continue;
                        ResourceLocation id = new ResourceLocation("fabrication", name.substring(ix + prePath.length()));
                        consumer.accept((Object)id, this.m_214146_(type, id));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Set<String> m_5698_(PackType type) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.meta.getAsJsonObject("fabrication").getAsJsonArray("namespaces"), JsonElement::getAsString));
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) throws IOException {
        if (!this.meta.has(metaReader.m_7991_())) {
            return null;
        }
        return (T)metaReader.m_6322_(this.meta.getAsJsonObject(metaReader.m_7991_()));
    }

    public String m_5542_() {
        return MixinConfigPlugin.MOD_NAME;
    }

    public void close() {
    }
}

