/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.unascribed.fabrication.ConvertedModInitializer;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.FabricationClientCommands;
import com.unascribed.fabrication.interfaces.SetFabricationConfigAware;
import com.unascribed.fabrication.support.ConfigLoader;
import com.unascribed.fabrication.support.ConfigValues;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.FabricationDefaultResources;
import com.unascribed.fabrication.support.Feature;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.OptionalFScript;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.common.Mod;

@Mod(value="fabrication")
public class FabricationMod
extends ConvertedModInitializer {
    private static final Map<String, Feature> features = Maps.newHashMap();
    private static final List<Feature> unconfigurableFeatures = Lists.newArrayList();
    private static final Set<String> enabledFeatures = Sets.newHashSet();
    public static final long LAUNCH_ID = ThreadLocalRandom.current().nextLong();
    public static SoundEvent LEVELUP_LONG;
    public static SoundEvent OOF;
    public static SoundEvent ABSORPTION_HURT;
    public static ResourceLocation CONFIG_ID1;
    public static ResourceLocation CONFIG_ID2;
    private static final BlockPos.MutableBlockPos scratchpos1;
    private static final BlockPos.MutableBlockPos scratchpos2;
    private static final BlockPos.MutableBlockPos scratchpos3;
    private static final BlockPos.MutableBlockPos scratchpos4;

    @Override
    public void onInitialize() {
        MixinConfigPlugin.loadComplete = true;
        for (String str : MixinConfigPlugin.discoverClassesInPackage("com.unascribed.fabrication.loaders", false)) {
            try {
                FabConf.introduce((ConfigLoader)Class.forName(str).newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (EarlyAgnos.isModLoaded("fscript")) {
            OptionalFScript.reload();
        }
        for (String s : MixinConfigPlugin.discoverClassesInPackage("com.unascribed.fabrication.features", false)) {
            try {
                String key;
                Feature r;
                block12: {
                    r = (Feature)Class.forName(s).newInstance();
                    key = FabConf.remap(r.getConfigKey());
                    if (key == null || FabConf.isEnabled(key)) {
                        try {
                            r.apply();
                            if (key == null) break block12;
                            enabledFeatures.add(key);
                        }
                        catch (Throwable t) {
                            FabricationMod.featureError(r, t, "Unknown");
                            continue;
                        }
                    }
                }
                if (key != null) {
                    features.put(key, r);
                    continue;
                }
                unconfigurableFeatures.add(r);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize feature " + s, e);
            }
        }
        if (EarlyAgnos.getCurrentEnv() == Env.CLIENT) {
            FabricationClientCommands.registerCommands();
            LEVELUP_LONG = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("fabrication", "levelup_long"));
            OOF = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("fabrication", "oof"));
            ABSORPTION_HURT = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("fabrication", "absorption_hurt"));
            FabricationDefaultResources.apply();
        }
    }

    public static void featureError(Feature f, Throwable t, String reason) {
        FabricationMod.featureError(f.getClass(), f.getConfigKey(), t, reason);
    }

    public static void featureError(Class<?> clazz, String configKey, Throwable t, String reason) {
        FabLog.debug("Original feature error", t);
        if (configKey == null) {
            FabLog.warn("Feature " + clazz.getName() + " failed to apply!");
        } else {
            FabLog.warn("Feature " + clazz.getName() + " failed to apply! Force-disabling " + configKey);
        }
        FabConf.addFailure(configKey, reason);
    }

    public static ResourceLocation createIdWithCustomDefault(String namespace, String pathOrId) {
        if (pathOrId.contains(":")) {
            return new ResourceLocation(pathOrId);
        }
        return new ResourceLocation(namespace, pathOrId);
    }

    public static boolean isAvailableFeature(String configKey) {
        return features.containsKey(FabConf.remap(configKey));
    }

    public static boolean updateFeature(String configKey) {
        configKey = FabConf.remap(configKey);
        boolean enabled = FabConf.isEnabled(configKey);
        if (enabledFeatures.contains(configKey) == enabled) {
            return true;
        }
        if (enabled) {
            features.get(configKey).apply();
            enabledFeatures.add(configKey);
            return true;
        }
        boolean b = features.get(configKey).undo();
        if (b) {
            enabledFeatures.remove(configKey);
        }
        return b;
    }

    public static Set<ServerPlayerConnection> getTrackers(Entity entity) {
        ServerChunkCache cm = ((ServerLevel)entity.m_9236_()).m_7726_();
        ChunkMap tacs = cm.f_8325_;
        Int2ObjectMap<ChunkMap.TrackedEntity> entityTrackers = FabRefl.getEntityTrackers(tacs);
        ChunkMap.TrackedEntity tracker = (ChunkMap.TrackedEntity)entityTrackers.get(entity.m_19879_());
        if (tracker == null) {
            return Collections.emptySet();
        }
        return FabRefl.getPlayersTracking(tracker);
    }

    public static void sendToTrackersMatching(Entity entity, ClientboundCustomPayloadPacket pkt, Predicate<ServerPlayer> predicate) {
        ServerPlayer spe;
        if (entity.m_9236_().f_46443_) {
            return;
        }
        Set<ServerPlayerConnection> playersTracking = FabricationMod.getTrackers(entity);
        if (entity instanceof ServerPlayer && predicate.test(spe = (ServerPlayer)entity)) {
            spe.f_8906_.m_9829_((Packet)pkt);
        }
        for (ServerPlayerConnection etl : playersTracking) {
            ServerPlayer spe2 = etl.m_142253_();
            if (!predicate.test(spe2)) continue;
            spe2.f_8906_.m_9829_((Packet)pkt);
        }
    }

    public static void sendConfigUpdate(MinecraftServer server, String key) {
        FriendlyByteBuf data = null;
        int lastVer = -1;
        List players = server.m_6846_().m_11314_();
        for (int i = 0; i < players.size(); ++i) {
            int reqVer;
            ServerPlayer spe = (ServerPlayer)players.get(i);
            if (!(spe instanceof SetFabricationConfigAware) || (reqVer = ((SetFabricationConfigAware)spe).fabrication$getReqVer()) < 0) continue;
            if (data == null || reqVer != lastVer) {
                lastVer = reqVer;
                data = FabricationMod.createConfigUpdateBuf(server, key, reqVer);
            }
            spe.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(reqVer == 0 ? CONFIG_ID1 : CONFIG_ID2, i + 1 == players.size() ? data : new FriendlyByteBuf(data.copy())));
        }
    }

    public static void sendConfigUpdate(MinecraftServer server, String key, ServerPlayer spe, int reqVer) {
        spe.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(reqVer == 0 ? CONFIG_ID1 : CONFIG_ID2, FabricationMod.createConfigUpdateBuf(server, key, reqVer)));
    }

    private static FriendlyByteBuf createConfigUpdateBuf(MinecraftServer server, String key, int reqVer) {
        if (key != null && key.startsWith("general.category")) {
            key = null;
        }
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        if (reqVer > 0) {
            data.m_130130_(1);
        }
        if (key == null) {
            HashMap trileans = Maps.newHashMap();
            HashMap strings = Maps.newHashMap();
            for (String k : FabConf.getAllKeys()) {
                if (k.startsWith("general.category")) {
                    strings.put(k, FabConf.getRawValue(k));
                    continue;
                }
                trileans.put(k, FabConf.getResolvedValue(k));
            }
            data.m_130130_(trileans.size());
            trileans.entrySet().forEach(en -> data.m_130070_((String)en.getKey()).writeByte(((ConfigValues.ResolvedFeature)((Object)((Object)en.getValue()))).ordinal()));
            data.m_130130_(strings.size());
            strings.entrySet().forEach(en -> data.m_130070_((String)en.getKey()).m_130070_((String)en.getValue()));
            data.writeLong(LAUNCH_ID);
        } else {
            data.m_130130_(1);
            data.m_130070_(key);
            data.writeByte(FabConf.getResolvedValue(key).ordinal());
            data.m_130130_(0);
            data.writeLong(LAUNCH_ID);
        }
        data.m_130070_(EarlyAgnos.getModVersion());
        data.m_130130_(FabConf.getAllFailures().size());
        if (reqVer > 0) {
            for (Object k : FabConf.getAllFailures().entrySet()) {
                data.m_130070_((String)k.getKey());
                data.m_130070_((String)k.getValue());
            }
        } else {
            for (Object k : FabConf.getAllFailures().keySet()) {
                data.m_130070_((String)k);
            }
        }
        data.m_130130_(FabConf.getAllBanned().size());
        for (Object k : FabConf.getAllBanned()) {
            data.m_130070_((String)k);
        }
        return data;
    }

    public static void forAllAdjacentBlocks(Entity entity, BlockScanCallback callback) {
        Level w = entity.m_9236_();
        AABB box = entity.m_20191_();
        if (!FabricationMod.scanBlocks(w, box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82289_, box.f_82293_, Direction.DOWN, callback)) {
            return;
        }
        if (!FabricationMod.scanBlocks(w, box.f_82288_, box.f_82292_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_, Direction.UP, callback)) {
            return;
        }
        if (!FabricationMod.scanBlocks(w, box.f_82288_, box.f_82289_, box.f_82290_, box.f_82288_, box.f_82292_, box.f_82293_, Direction.WEST, callback)) {
            return;
        }
        if (!FabricationMod.scanBlocks(w, box.f_82291_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_, Direction.EAST, callback)) {
            return;
        }
        if (!FabricationMod.scanBlocks(w, box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82290_, Direction.NORTH, callback)) {
            return;
        }
        if (!FabricationMod.scanBlocks(w, box.f_82288_, box.f_82289_, box.f_82293_, box.f_82291_, box.f_82292_, box.f_82293_, Direction.SOUTH, callback)) {
            return;
        }
    }

    private static boolean scanBlocks(Level w, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Direction dir, BlockScanCallback callback) {
        BlockPos.MutableBlockPos min = scratchpos1.m_122169_(minX + (double)dir.m_122429_(), minY + (double)dir.m_122430_(), minZ + (double)dir.m_122431_());
        BlockPos.MutableBlockPos max = scratchpos2.m_122169_(maxX + (double)dir.m_122429_(), maxY + (double)dir.m_122430_(), maxZ + (double)dir.m_122431_());
        BlockPos.MutableBlockPos mut = scratchpos3;
        if (w.m_46832_((BlockPos)min, (BlockPos)max)) {
            for (int x = min.m_123341_(); x <= max.m_123341_(); ++x) {
                for (int y = min.m_123342_(); y <= max.m_123342_(); ++y) {
                    for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                        mut.m_122178_(x, y, z);
                        scratchpos4.m_122190_((Vec3i)mut);
                        if (callback.invoke(w, mut, scratchpos4, dir)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    static {
        CONFIG_ID1 = new ResourceLocation("fabrication", "config");
        CONFIG_ID2 = new ResourceLocation("fabrication", "config2");
        scratchpos1 = new BlockPos.MutableBlockPos();
        scratchpos2 = new BlockPos.MutableBlockPos();
        scratchpos3 = new BlockPos.MutableBlockPos();
        scratchpos4 = new BlockPos.MutableBlockPos();
    }

    public static interface BlockScanCallback {
        public boolean invoke(Level var1, BlockPos.MutableBlockPos var2, BlockPos.MutableBlockPos var3, Direction var4);
    }
}

