/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.main.network;

import com.dooji.underlay.client.UnderlayClient;
import com.dooji.underlay.main.UnderlayManager;
import com.dooji.underlay.main.network.payloads.AddOverlayPayload;
import com.dooji.underlay.main.network.payloads.RemoveOverlayPayload;
import com.dooji.underlay.main.network.payloads.SyncOverlaysPayload;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class UnderlayNetworking {
    private static final String PROTOCOL_VERSION = "1";
    public static final ResourceLocation NETWORK_CHANNEL = ResourceLocation.m_214293_((String)"underlay", (String)"main");
    public static SimpleChannel INSTANCE;

    public static void init() {
        INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)NETWORK_CHANNEL).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(v -> true).serverAcceptedVersions(v -> true).simpleChannel();
        int id = 0;
        INSTANCE.messageBuilder(SyncOverlaysPayload.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncOverlaysPayload::write).decoder(SyncOverlaysPayload::read).consumerNetworkThread((msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (context.getDirection().getReceptionSide().isClient()) {
                context.enqueueWork(() -> UnderlayClient.handleSyncPacket(msg));
            }
            context.setPacketHandled(true);
        }).add();
        INSTANCE.messageBuilder(AddOverlayPayload.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(AddOverlayPayload::write).decoder(AddOverlayPayload::read).consumerNetworkThread((msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (context.getDirection().getReceptionSide().isClient()) {
                context.enqueueWork(() -> UnderlayClient.handleAddPacket(msg));
            }
            context.setPacketHandled(true);
        }).add();
        INSTANCE.messageBuilder(RemoveOverlayPayload.class, id++, null).encoder(RemoveOverlayPayload::write).decoder(RemoveOverlayPayload::read).consumerNetworkThread((msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (context.getDirection().getReceptionSide().isServer()) {
                context.enqueueWork(() -> {
                    BlockPos pos;
                    ServerPlayer player = context.getSender();
                    if (player == null) {
                        return;
                    }
                    ServerLevel world = player.m_284548_();
                    if (!world.m_46805_(pos = msg.pos()) || !world.m_6857_().m_61937_(pos)) {
                        return;
                    }
                    if (!world.m_7966_((Player)player, pos)) {
                        return;
                    }
                    if (UnderlayManager.hasOverlay((Level)world, pos)) {
                        BlockState oldState = UnderlayManager.getOverlay((Level)world, pos);
                        UnderlayManager.removeOverlay((Level)world, pos);
                        if (!player.m_7500_()) {
                            world.m_7967_((Entity)new ItemEntity((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)oldState.m_60734_())));
                        }
                        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.m_46745_(pos)), (Object)new RemoveOverlayPayload(pos));
                    }
                });
            } else if (FMLEnvironment.dist == Dist.CLIENT) {
                context.enqueueWork(() -> UnderlayClient.handleRemovePacket(msg));
            }
            context.setPacketHandled(true);
        }).add();
    }

    public static void syncOverlaysToPlayer(ServerPlayer player) {
        ServerLevel world = player.m_284548_();
        HashMap<BlockPos, CompoundTag> tags = new HashMap<BlockPos, CompoundTag>();
        UnderlayManager.getOverlaysFor((Level)world).forEach((pos, state) -> tags.put((BlockPos)pos, NbtUtils.m_129202_((BlockState)state)));
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncOverlaysPayload(tags));
    }

    public static void broadcastAdd(ServerLevel world, BlockPos pos) {
        CompoundTag tag = NbtUtils.m_129202_((BlockState)UnderlayManager.getOverlay((Level)world, pos));
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.m_46745_(pos)), (Object)new AddOverlayPayload(pos, tag));
    }
}

