/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.main.events;

import com.dooji.underlay.main.UnderlayApi;
import com.dooji.underlay.main.UnderlayManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="underlay")
public class BlockInteractionEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleOverlayPlacement(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ItemStack stack = event.getItemStack();
        if (!(stack.m_41720_() instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)stack.m_41720_();
        Block block = blockItem.m_40614_();
        Direction face = event.getFace();
        BlockPos clickedPos = event.getPos();
        if (face != Direction.UP) {
            return;
        }
        BlockPos targetPos = clickedPos.m_7494_();
        ServerLevel world = (ServerLevel)event.getLevel();
        BlockPlaceContext context = new BlockPlaceContext(new UseOnContext((Player)player, event.getHand(), event.getHitVec()));
        BlockState newState = block.m_5573_(context);
        BlockState existingState = world.m_8055_(targetPos);
        if (newState != null && existingState.m_60734_() == block && newState.m_60734_() == block) {
            return;
        }
        if (!UnderlayApi.isOverlayBlock(block)) {
            return;
        }
        if (existingState.m_60795_()) {
            return;
        }
        if (Block.m_49916_((VoxelShape)existingState.m_60808_((BlockGetter)world, targetPos))) {
            return;
        }
        if (!existingState.m_60819_().m_76178_()) {
            return;
        }
        if (!world.m_7966_((Player)player, targetPos)) {
            return;
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
        UnderlayManager.addOverlay(player, (Level)world, targetPos, newState);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        SoundType sound = newState.m_60827_();
        world.m_5594_((Player)player, targetPos, sound.m_56777_(), SoundSource.BLOCKS, sound.m_56773_(), sound.m_56774_());
    }
}

