/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.main;

import com.dooji.underlay.main.Underlay;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelResource;

public class UnderlayPersistenceHandler {
    private static final int MAX_OVERLAY_SAVE_ATTEMPTS = 3;

    private static String getSaveFileName(Level world) {
        String dimensionId = world.m_46472_().m_135782_().toString();
        if ("minecraft:overworld".equals(dimensionId)) {
            return "underlays.dat";
        }
        return "underlays_" + dimensionId.replace(':', '_') + ".dat";
    }

    public static void saveOverlays(Level world, Map<BlockPos, BlockState> overlays) {
        if (world == null || overlays == null) {
            Underlay.LOGGER.warn("Attempted to save overlays with null parameters");
            return;
        }
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                CompoundTag rootTag = new CompoundTag();
                ListTag overlayList = new ListTag();
                for (Map.Entry<BlockPos, BlockState> entry : overlays.entrySet()) {
                    BlockPos pos = entry.getKey();
                    BlockState state = entry.getValue();
                    CompoundTag overlayTag = new CompoundTag();
                    overlayTag.m_128405_("x", pos.m_123341_());
                    overlayTag.m_128405_("y", pos.m_123342_());
                    overlayTag.m_128405_("z", pos.m_123343_());
                    overlayTag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)state));
                    overlayList.add((Object)overlayTag);
                }
                rootTag.m_128365_("overlays", (Tag)overlayList);
                ServerLevel serverWorld = (ServerLevel)world;
                Path saveDir = serverWorld.m_7654_().m_129843_(LevelResource.f_78182_).resolve("data");
                String fileName = UnderlayPersistenceHandler.getSaveFileName(world);
                File saveFile = saveDir.resolve(fileName).toFile();
                saveDir.toFile().mkdirs();
                try (FileOutputStream fos = new FileOutputStream(saveFile);){
                    NbtIo.m_128947_((CompoundTag)rootTag, (OutputStream)fos);
                    break;
                }
            }
            catch (IOException e) {
                Underlay.LOGGER.error("Failed to save overlays (Attempt " + (attempt + 1) + ")", (Throwable)e);
                try {
                    Thread.sleep(100 * (attempt + 1));
                    continue;
                }
                catch (InterruptedException ie) {
                    Underlay.LOGGER.warn("Overlay save interrupted", (Throwable)ie);
                    break;
                }
            }
        }
    }

    public static Map<BlockPos, BlockState> loadOverlays(Level world) {
        HashMap<BlockPos, BlockState> overlays;
        block14: {
            overlays = new HashMap<BlockPos, BlockState>();
            if (world == null) {
                Underlay.LOGGER.warn("Attempted to load overlays with null world");
                return overlays;
            }
            if (world.m_5776_() || !(world instanceof ServerLevel)) {
                return overlays;
            }
            try {
                ServerLevel serverWorld = (ServerLevel)world;
                Path saveDir = serverWorld.m_7654_().m_129843_(LevelResource.f_78182_).resolve("data");
                String fileName = UnderlayPersistenceHandler.getSaveFileName(world);
                File saveFile = saveDir.resolve(fileName).toFile();
                if (!saveFile.exists()) {
                    Underlay.LOGGER.info("No existing overlay save file found");
                    return overlays;
                }
                try (FileInputStream fis = new FileInputStream(saveFile);){
                    CompoundTag rootTag = NbtIo.m_128939_((InputStream)fis);
                    if (!rootTag.m_128441_("overlays")) break block14;
                    ListTag overlayList = rootTag.m_128437_("overlays", 10);
                    for (int i = 0; i < overlayList.size(); ++i) {
                        CompoundTag overlayTag = overlayList.m_128728_(i);
                        int x = overlayTag.m_128451_("x");
                        int y = overlayTag.m_128451_("y");
                        int z = overlayTag.m_128451_("z");
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = null;
                        if (overlayTag.m_128441_("state")) {
                            try {
                                CompoundTag stateTag = overlayTag.m_128469_("state");
                                state = NbtUtils.m_247651_((HolderGetter)serverWorld.m_246945_(Registries.f_256747_), (CompoundTag)stateTag);
                            }
                            catch (Exception e) {
                                Underlay.LOGGER.warn("Failed to read block state from NBT", (Throwable)e);
                            }
                        }
                        if (state == null) continue;
                        overlays.put(pos, state);
                    }
                    Underlay.LOGGER.info("Loaded " + overlays.size() + " overlays");
                }
            }
            catch (IOException e) {
                Underlay.LOGGER.error("Failed to load overlays", (Throwable)e);
            }
        }
        return overlays;
    }
}

