/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.main;

import com.dooji.underlay.main.Underlay;
import com.dooji.underlay.main.UnderlayApi;
import com.dooji.underlay.main.UnderlayPersistenceHandler;
import com.dooji.underlay.main.network.UnderlayNetworking;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class UnderlayManager {
    private static final Map<String, Map<BlockPos, BlockState>> OVERLAYS = new ConcurrentHashMap<String, Map<BlockPos, BlockState>>();

    public static void addOverlay(ServerPlayer player, Level world, BlockPos pos, BlockState blockState) {
        if (world == null || pos == null || blockState == null) {
            Underlay.LOGGER.warn("Attempted to add overlay with null parameters");
            return;
        }
        if (!UnderlayApi.isOverlayBlock(blockState.m_60734_())) {
            Underlay.LOGGER.warn("Attempted to add non-overlay block as overlay: " + String.valueOf(blockState));
            return;
        }
        String dimensionKey = UnderlayManager.getDimensionKey(world);
        Map worldOverlays = OVERLAYS.computeIfAbsent(dimensionKey, k -> new ConcurrentHashMap());
        if (worldOverlays.containsKey(pos)) {
            BlockState old = (BlockState)worldOverlays.get(pos);
            if (!player.m_7500_()) {
                world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)old.m_60734_())));
            }
        }
        try {
            worldOverlays.put(pos.m_7949_(), blockState);
            UnderlayNetworking.broadcastAdd((ServerLevel)world, pos);
            if (!world.m_5776_() && world instanceof ServerLevel) {
                UnderlayPersistenceHandler.saveOverlays(world, worldOverlays);
            }
        }
        catch (Exception e) {
            Underlay.LOGGER.error("Failed to add overlay at " + String.valueOf(pos), (Throwable)e);
        }
    }

    public static boolean removeOverlay(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            Underlay.LOGGER.warn("Attempted to remove overlay with null parameters");
            return false;
        }
        String dimensionKey = UnderlayManager.getDimensionKey(world);
        Map<BlockPos, BlockState> worldOverlays = OVERLAYS.get(dimensionKey);
        try {
            if (worldOverlays != null && worldOverlays.containsKey(pos)) {
                worldOverlays.remove(pos);
                if (!world.m_5776_() && world instanceof ServerLevel) {
                    UnderlayPersistenceHandler.saveOverlays(world, worldOverlays);
                }
                return true;
            }
        }
        catch (Exception e) {
            Underlay.LOGGER.error("Failed to remove overlay at " + String.valueOf(pos), (Throwable)e);
        }
        return false;
    }

    public static boolean hasOverlay(Level world, BlockPos pos) {
        String dimensionKey = UnderlayManager.getDimensionKey(world);
        Map<BlockPos, BlockState> worldOverlays = OVERLAYS.get(dimensionKey);
        return worldOverlays != null && worldOverlays.containsKey(pos);
    }

    public static BlockState getOverlay(Level world, BlockPos pos) {
        String dimensionKey = UnderlayManager.getDimensionKey(world);
        Map<BlockPos, BlockState> worldOverlays = OVERLAYS.get(dimensionKey);
        if (worldOverlays != null && worldOverlays.containsKey(pos)) {
            return worldOverlays.get(pos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static Map<BlockPos, BlockState> getOverlaysFor(Level world) {
        String key = world.m_46472_().m_135782_().toString();
        return OVERLAYS.getOrDefault(key, Map.of());
    }

    public static void loadOverlays(Level world) {
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        String dimensionKey = UnderlayManager.getDimensionKey(world);
        Map<BlockPos, BlockState> worldOverlays = UnderlayPersistenceHandler.loadOverlays(world);
        OVERLAYS.put(dimensionKey, worldOverlays);
        Underlay.LOGGER.info("Loaded " + worldOverlays.size() + " overlays for dimension " + dimensionKey);
    }

    private static String getDimensionKey(Level world) {
        return world.m_46472_().m_135782_().toString();
    }
}

