/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.client;

import com.dooji.underlay.client.UnderlayManagerClient;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;

public class UnderlayRenderer {
    private static final Map<BlockPos, BlockState> RENDER_CACHE = new ConcurrentHashMap<BlockPos, BlockState>();
    private static long lastFullRefreshTime = 0L;
    private static final long FULL_REFRESH_INTERVAL = 500L;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(UnderlayRenderer::onRenderLevel);
    }

    public static void registerOverlay(BlockPos pos, BlockState state) {
        RENDER_CACHE.put(pos.m_7949_(), state);
    }

    public static void unregisterOverlay(BlockPos pos) {
        RENDER_CACHE.remove(pos);
    }

    public static void clearAllOverlays() {
        RENDER_CACHE.clear();
    }

    public static void forceRefresh() {
        lastFullRefreshTime = System.currentTimeMillis();
        UnderlayRenderer.clearAllOverlays();
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ != null && client.f_91074_ != null) {
            BlockPos playerPos = client.f_91074_.m_20183_();
            int radius = 64;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -16; y <= 16; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos pos = playerPos.m_7918_(x, y, z);
                        if (!UnderlayManagerClient.hasOverlay(pos)) continue;
                        UnderlayRenderer.registerOverlay(pos, UnderlayManagerClient.getOverlay(pos));
                    }
                }
            }
        }
    }

    private static void checkForFullRefresh() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastFullRefreshTime > 500L) {
            UnderlayRenderer.forceRefresh();
        }
    }

    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        BlockRenderDispatcher blockRenderer = client.m_91289_();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 cameraPos = client.f_91063_.m_109153_().m_90583_();
        RandomSource randomSource = RandomSource.m_216327_();
        RandomSource renderTypeRandom = RandomSource.m_216327_();
        HashSet<RenderType> usedRenderTypes = new HashSet<RenderType>();
        if (bufferSource == null || client.f_91073_ == null || client.f_91074_ == null) {
            return;
        }
        UnderlayRenderer.checkForFullRefresh();
        poseStack.m_85836_();
        for (Map.Entry<BlockPos, BlockState> entry : RENDER_CACHE.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue();
            int chunks = (Integer)client.f_91066_.m_231984_().m_231551_();
            int blocks = chunks * 16;
            double maxDistSq = (double)blocks * (double)blocks;
            double distanceSq = pos.m_123331_((Vec3i)client.f_91074_.m_20183_());
            if (distanceSq > maxDistSq) continue;
            if (!UnderlayManagerClient.hasOverlay(pos)) {
                RENDER_CACHE.remove(pos);
                continue;
            }
            poseStack.m_85836_();
            poseStack.m_85837_((double)pos.m_123341_() - cameraPos.f_82479_, (double)pos.m_123342_() - cameraPos.f_82480_, (double)pos.m_123343_() - cameraPos.f_82481_);
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_85841_(1.0001f, 1.0001f, 1.0001f);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            BakedModel model = blockRenderer.m_110910_(state);
            ModelData modelData = ModelData.EMPTY;
            renderTypeRandom.m_188584_(42L);
            for (RenderType chunkRenderType : model.getRenderTypes(state, renderTypeRandom, modelData)) {
                RenderType movingRenderType = RenderTypeHelper.getMovingBlockRenderType((RenderType)chunkRenderType);
                VertexConsumer vertexConsumer = bufferSource.m_6299_(movingRenderType);
                blockRenderer.renderBatched(state, pos, (BlockAndTintGetter)client.f_91073_, poseStack, vertexConsumer, false, randomSource, modelData, chunkRenderType);
                usedRenderTypes.add(movingRenderType);
            }
            poseStack.m_85849_();
        }
        for (RenderType usedType : usedRenderTypes) {
            bufferSource.m_109912_(usedType);
        }
        poseStack.m_85849_();
    }
}

