/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.particle.FeatherParticle;
import einstein.subtle_effects.particle.option.SheepFluffParticleOptions;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class SheepFluffParticle
extends FeatherParticle {
    private final int sheepId;
    private final boolean isJeb;
    private final Entity sheep;

    protected SheepFluffParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites, SheepFluffParticleOptions options) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprites);
        this.sheepId = options.sheepId();
        this.isJeb = options.isJeb();
        this.sheep = this.isJeb ? level.m_6815_(this.sheepId) : null;
        this.f_107226_ = 0.5f;
        if (!this.isJeb) {
            float[] color = Sheep.m_29829_((DyeColor)options.color());
            this.m_107253_(color[0], color[1], color[2]);
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        if (this.isJeb) {
            int speed = 25;
            int tickCount = this.sheep.f_19797_;
            int i = tickCount / speed + this.sheepId;
            int length = DyeColor.values().length;
            float delta = ((float)(tickCount % speed) + partialTicks) / (float)speed;
            float[] startColor = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)(i % length)));
            float[] endColor = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)((i + 1) % length)));
            this.m_107253_(startColor[0] * (1.0f - delta) + endColor[0] * delta, startColor[1] * (1.0f - delta) + endColor[1] * delta, startColor[2] * (1.0f - delta) + endColor[2] * delta);
        }
        super.m_5744_(buffer, renderInfo, partialTicks);
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SheepFluffParticleOptions>
    {
        public Particle createParticle(SheepFluffParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SheepFluffParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites, options);
        }
    }
}

