/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.ColorAndIntegerParticleOptions;
import einstein.subtle_effects.util.LifetimeAlpha;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class PotionRingParticle
extends FlatPlaneParticle {
    @Nullable
    private final Entity entity;
    private final boolean hasEntity;
    private double yDistance;
    private final LifetimeAlpha fadeInLifetimeAlpha;
    private final LifetimeAlpha fadeOutLifetimeAlpha;

    protected PotionRingParticle(ClientLevel level, double x, double y, double z, @Nullable Entity entity, SpriteSet sprites) {
        super(level, x, y, z);
        this.fadeInLifetimeAlpha = new LifetimeAlpha(0.0f, ((Float)ModConfigs.ENTITIES.humanoids.potionRingsAlpha.get()).floatValue(), 0.0f, 0.5f);
        this.fadeOutLifetimeAlpha = new LifetimeAlpha(((Float)ModConfigs.ENTITIES.humanoids.potionRingsAlpha.get()).floatValue(), 0.0f, 0.5f, 1.0f);
        this.entity = entity;
        this.hasEntity = entity != null;
        this.yDistance = this.hasEntity ? y - entity.m_20186_() : 0.0;
        this.f_107225_ = 10;
        this.f_107230_ = 0.0f;
        this.f_107663_ = 0.2f;
        this.rotation.rotateX(-1.5707964f);
        this.m_108335_(sprites);
        this.m_6569_(3.0f * ((Float)ModConfigs.ENTITIES.humanoids.potionRingsScale.get()).floatValue());
    }

    @Override
    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTicks) {
        this.f_107230_ = Math.min(this.fadeInLifetimeAlpha.currentAlphaForAge(this.f_107224_, this.f_107225_, partialTicks), this.fadeOutLifetimeAlpha.currentAlphaForAge(this.f_107224_, this.f_107225_, partialTicks));
        super.m_5744_(consumer, camera, partialTicks);
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        float halfLife = (float)this.f_107225_ / 2.0f;
        this.f_107216_ += 0.25 / (double)halfLife * (double)((float)this.f_107224_ > halfLife ? -1 : 1);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.m_6257_(0.0, this.f_107216_, 0.0);
        this.f_107216_ *= (double)this.f_172258_;
        if (this.hasEntity) {
            this.yDistance += this.f_107213_ - this.f_107210_;
            this.m_107264_(this.entity.m_20185_(), this.entity.m_20186_() + this.yDistance, this.entity.m_20189_());
        }
    }

    public void m_6257_(double x, double y, double z) {
        if (y != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(x, y, z));
            this.m_107275_();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<ColorAndIntegerParticleOptions>
    {
        public Particle createParticle(ColorAndIntegerParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PotionRingParticle particle = new PotionRingParticle(level, x, y, z, level.m_6815_(options.integer()), this.sprites);
            Util.setColorFromHex((Particle)particle, options.color());
            return particle;
        }
    }
}

