/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle.bubbles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.data.BCWPPackManager;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.DrowningBubbleParticle;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.BubbleSetter;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BubbleColumnUpParticle;
import net.minecraft.client.particle.BubbleParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.particle.WaterCurrentDownParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BubbleParticle.class, BubbleColumnUpParticle.class, WaterCurrentDownParticle.class})
public abstract class BubbleParticleMixin
extends TextureSheetParticle
implements BubbleSetter {
    @Unique
    private TextureAtlasSprite subtleEffects$overlaySprite;
    @Unique
    private boolean subtleEffects$playsSound;
    @Unique
    private int subtleEffects$waterColor;

    protected BubbleParticleMixin(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        this.subtleEffects$waterColor = ((Biome)this.f_107208_.m_204166_(pos).m_203334_()).m_47560_();
        if (!this.m_107276_()) {
            float volume = ((Float)ModConfigs.GENERAL.poppingBubblesVolume.get()).floatValue();
            if (this.subtleEffects$playsSound && volume > 0.0f && !this.f_107208_.m_46801_(pos)) {
                this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, SoundEvents.f_11773_, SoundSource.AMBIENT, (float)Mth.m_216271_((RandomSource)this.f_107223_, (int)1, (int)4) * volume, Mth.m_216267_((RandomSource)this.f_107223_, (float)1.0f, (float)1.3f), false);
            }
            if (ModConfigs.GENERAL.poppingBubbles) {
                if (this instanceof DrowningBubbleParticle) {
                    this.f_107208_.m_7106_((ParticleOptions)ModParticles.DROWNING_BUBBLE_POP.get(), this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
                    return;
                }
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123772_, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
            }
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        super.m_5744_(buffer, camera, partialTicks);
        if (this.subtleEffects$overlaySprite != null) {
            Quaternionf quaternion;
            int lightColor = this.m_6355_(partialTicks);
            float quadSize = this.m_5902_(partialTicks);
            float u0 = this.subtleEffects$overlaySprite.m_118409_();
            float u1 = this.subtleEffects$overlaySprite.m_118410_();
            float v0 = this.subtleEffects$overlaySprite.m_118411_();
            float v1 = this.subtleEffects$overlaySprite.m_118412_();
            Vec3 cameraPos = camera.m_90583_();
            float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
            float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
            float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
            if (this.f_107231_ == 0.0f) {
                quaternion = camera.m_253121_();
            } else {
                quaternion = new Quaternionf((Quaternionfc)camera.m_253121_());
                quaternion.rotateZ(Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_));
            }
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, -1.0f, -1.0f, quadSize, u0, v1, lightColor);
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, -1.0f, 1.0f, quadSize, u0, v0, lightColor);
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, 1.0f, 1.0f, quadSize, u1, v0, lightColor);
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, 1.0f, -1.0f, quadSize, u1, v1, lightColor);
        }
    }

    @Unique
    private void subtleEffects$renderVertex(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)quaternion).mul(quadSize).add(x, y, z);
        float colorIntensity = 0.2f;
        float whiteIntensity = 1.0f - colorIntensity;
        buffer.m_5483_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).m_7421_(u, v).m_85950_(whiteIntensity + colorIntensity * ((float)(this.subtleEffects$waterColor >> 16 & 0xFF) / 255.0f), whiteIntensity + colorIntensity * ((float)(this.subtleEffects$waterColor >> 8 & 0xFF) / 255.0f), whiteIntensity + colorIntensity * ((float)(this.subtleEffects$waterColor & 0xFF) / 255.0f), this.f_107230_).m_85969_(packedLight).m_5752_();
    }

    @Override
    public void subtleEffects$setupBubble(SpriteSet sprites, boolean playsSound) {
        List<TextureAtlasSprite> textures = Services.PARTICLE_HELPER.getSpritesFromSet(sprites);
        this.subtleEffects$playsSound = playsSound;
        if (textures != null && textures.size() > 1 && BCWPPackManager.isPackLoaded()) {
            this.m_108337_(textures.get(0));
            this.subtleEffects$overlaySprite = textures.get(1);
        }
    }
}

