/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.event;

import com.google.common.collect.ImmutableList;
import com.izofar.takesapillage.config.ModCommonConfigs;
import com.izofar.takesapillage.entity.ClayGolem;
import com.izofar.takesapillage.init.ModEntityTypes;
import com.izofar.takesapillage.util.IMobRememberSpawnReason;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class ModEntityEvents {
    private static final Queue<ClayGolem> CLAY_GOLEMS = new LinkedList<ClayGolem>();

    @SubscribeEvent
    public static void replaceNaturallySpawningIronGolemWithClayGolem(EntityJoinLevelEvent event) {
        if (!((Boolean)ModCommonConfigs.REPLACE_IRON_GOLEMS.get()).booleanValue()) {
            return;
        }
        double replacementRate = ModCommonConfigs.getReplacementRate(event.getLevel().m_46791_());
        Entity entity = event.getEntity();
        if (entity instanceof IronGolem) {
            Level level;
            IronGolem ironGolem = (IronGolem)entity;
            if (entity.getClass() == IronGolem.class && (level = event.getLevel()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (((IMobRememberSpawnReason)ironGolem).getMobSpawnType() != MobSpawnType.COMMAND && !ironGolem.m_28876_() && event.getLevel().m_213780_().m_188500_() < replacementRate) {
                    ClayGolem clayGolem = (ClayGolem)((EntityType)ModEntityTypes.CLAY_GOLEM.get()).m_20615_((Level)serverLevel);
                    if (clayGolem == null) {
                        return;
                    }
                    clayGolem.m_20219_(ironGolem.m_20182_());
                    CLAY_GOLEMS.add(clayGolem);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void checkForUnSpawnedGolem(TickEvent.LevelTickEvent event) {
        if (!((Boolean)ModCommonConfigs.REPLACE_IRON_GOLEMS.get()).booleanValue()) {
            return;
        }
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LinkedList<ClayGolem> clayGolemQueue = new LinkedList<ClayGolem>();
            for (ClayGolem entity : CLAY_GOLEMS) {
                if (!serverLevel.isAreaLoaded(entity.m_20183_(), 0)) continue;
                serverLevel.m_7967_((Entity)entity);
                clayGolemQueue.add(entity);
            }
            CLAY_GOLEMS.removeAll(clayGolemQueue);
        }
    }

    @SubscribeEvent
    public static void preventMilkFromRemovingBadOmen(MobEffectEvent event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null && effectInstance.m_19544_().equals(MobEffects.f_19594_) && !((Boolean)ModCommonConfigs.REMOVE_BAD_OMEN.get()).booleanValue()) {
            event.getEffectInstance().setCurativeItems((List)ImmutableList.of());
        }
    }
}

