/*
 * Decompiled with CFR 0.152.
 */
package toni.miningspeedtooltips;

import java.text.DecimalFormat;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toni.lib.utils.PlatformUtils;

@Mod(value="miningspeedtooltips")
public class MiningSpeedTooltips {
    public static final String MODNAME = "Mining Speed Tooltips";
    public static final String ID = "miningspeedtooltips";
    public static final Logger LOGGER = LogManager.getLogger((String)"Mining Speed Tooltips");

    public MiningSpeedTooltips() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
    }

    public void onInitialize() {
        ItemTooltipCallback.EVENT.register((itemStack, tooltipContext, tooltip) -> {
            String speed = this.getTooltip(itemStack);
            if (speed != null) {
                tooltip.add(Component.m_237113_((String)speed).m_130940_(ChatFormatting.DARK_GREEN));
            }
        });
    }

    public void onInitializeClient() {
    }

    public String getTooltip(ItemStack itemStack) {
        if (PlatformUtils.isModLoaded((String)"quark") && !Screen.m_96638_()) {
            return null;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof DiggerItem) {
            DiggerItem item2 = (DiggerItem)item;
            float speed = item2.m_43314_().m_6624_();
            int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)itemStack);
            if (level > 0) {
                speed += (float)(level * level + 1);
            }
            return " " + DecimalFormat.getInstance().format(speed) + " Mining Speed";
        }
        return null;
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        this.onInitialize();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.onInitializeClient();
    }
}

