/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.handler;

import fuzs.mindfuldarkness.MindfulDarkness;
import fuzs.mindfuldarkness.client.util.HSPConversionUtil;
import fuzs.mindfuldarkness.client.util.RGBBrightnessUtil;
import fuzs.mindfuldarkness.config.ClientConfig;
import java.util.Objects;
import java.util.OptionalInt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;

public class FontColorHandler {
    private static boolean renderInDarkness;

    public static void onBeforeRender(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta) {
        String identifier = FontColorHandler.identifyScreen(screen);
        if (identifier == null || !((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).fontColorBlacklist.contains(identifier)) {
            renderInDarkness = true;
        }
    }

    @Nullable
    public static String identifyScreen(Screen screen) {
        Objects.requireNonNull(screen, "screen is null");
        Component title = screen.m_96636_();
        ComponentContents componentContents = title.m_214077_();
        if (componentContents instanceof LiteralContents) {
            LiteralContents literalContents = (LiteralContents)componentContents;
            return literalContents.f_237368_();
        }
        componentContents = title.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            return translatableContents.m_237508_();
        }
        if (screen instanceof BookEditScreen) {
            return "book.edit";
        }
        if (screen instanceof BookViewScreen) {
            return "book.view";
        }
        return null;
    }

    public static void onAfterRender(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta) {
        renderInDarkness = false;
    }

    public static int adjustFontColor(int fontColor) {
        if (renderInDarkness && MindfulDarkness.CONFIG.getHolder(ClientConfig.class).isAvailable() && ((Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get()).booleanValue()) {
            return FontColorHandler.tryAdjustColor(fontColor).orElse(fontColor);
        }
        return fontColor;
    }

    private static OptionalInt tryAdjustColor(int color) {
        double targetBrightness;
        double[] hspColorArray = RGBBrightnessUtil.unpackRGBToHSP(color);
        if (hspColorArray[2] < (targetBrightness = ((Double)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).fontBrightness.get()).doubleValue())) {
            double[] rgbColorArray = HSPConversionUtil.HSPtoRGB(hspColorArray[0], hspColorArray[1], targetBrightness);
            return OptionalInt.of(RGBBrightnessUtil.packRGBColor(rgbColorArray));
        }
        return OptionalInt.empty();
    }
}

