/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class LanternDecorator
extends TreeDecorator {
    public static final Codec<LanternDecorator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)IntProvider.m_146545_((int)0, (int)10).fieldOf("lantern_count").orElse((Object)ConstantInt.m_146483_((int)3)).forGetter(decorator -> decorator.count), (App)IntProvider.m_146545_((int)0, (int)10).fieldOf("chain_length").orElse((Object)ConstantInt.m_146483_((int)1)).forGetter(decorator -> decorator.chainLength)).apply((Applicative)builder, LanternDecorator::new));
    private final BlockState chain = (BlockState)Blocks.f_50184_.m_49966_().m_61124_((Property)ChainBlock.f_55923_, (Comparable)Direction.Axis.Y);
    private final BlockState lantern = (BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.TRUE);
    private final float probability;
    private final IntProvider count;
    private final IntProvider chainLength;

    public LanternDecorator(float probability, IntProvider count, IntProvider chainLength) {
        this.probability = probability;
        this.count = count;
        this.chainLength = chainLength;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return ModRegistry.LANTERN.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        if (random.m_188501_() > this.probability) {
            return;
        }
        int count = this.count.m_214085_(random);
        List<BlockPos> possible = LanternDecorator.getLeavesShuffled(context, count);
        for (int i = 0; i < possible.size(); ++i) {
            BlockPos blockpos = possible.get(i);
            for (int length = this.chainLength.m_214085_(random); context.m_226059_(blockpos) && length > 0; --length) {
                context.m_226061_(blockpos, this.chain);
                blockpos = blockpos.m_7495_();
            }
            context.m_226061_(blockpos, this.lantern);
        }
    }

    private static List<BlockPos> getLeavesShuffled(TreeDecorator.Context context, int maxCount) {
        List<BlockPos> all = context.m_226069_().stream().map(BlockPos::m_7495_).filter(arg_0 -> ((TreeDecorator.Context)context).m_226059_(arg_0)).distinct().collect(Collectors.toList());
        Collections.shuffle(all);
        int maxIndex = Math.min(maxCount, all.size());
        all.subList(maxIndex, all.size()).clear();
        return all;
    }
}

