/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.util;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlockPosUtils {
    public static Iterable<BlockPos> betweenClosed(AABB box) {
        BlockPos min = BlockPos.m_274561_((double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_);
        BlockPos max = BlockPos.m_274561_((double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_);
        return BlockPos.m_121940_((BlockPos)min, (BlockPos)max);
    }

    public static boolean forEachBlockIntersectedBetween(Vec3 start, Vec3 end, AABB aabb, BlockStepVisitor visitor) {
        Vec3 direction = end.m_82546_(start);
        if (direction.m_82556_() < (double)Mth.m_14207_((float)0.99999f)) {
            for (BlockPos pos : BlockPosUtils.betweenClosed(aabb)) {
                if (visitor.visit(pos, 0)) continue;
                return false;
            }
            return true;
        }
        LongOpenHashSet visitedPositions = new LongOpenHashSet();
        Vec3 minPosition = new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_);
        Vec3 startOffset = minPosition.m_82546_(direction);
        int stepCount = BlockPosUtils.addCollisionsAlongTravel((LongSet)visitedPositions, startOffset, minPosition, aabb, visitor);
        if (stepCount < 0) {
            return false;
        }
        for (BlockPos pos : BlockPosUtils.betweenClosed(aabb)) {
            if (visitedPositions.contains(pos.m_121878_()) || visitor.visit(pos, stepCount + 1)) continue;
            return false;
        }
        return true;
    }

    private static int addCollisionsAlongTravel(LongSet visitedPositions, Vec3 startPos, Vec3 endPos, AABB box, BlockStepVisitor visitor) {
        Vec3 travel = endPos.m_82546_(startPos);
        int startX = Mth.m_14107_((double)startPos.f_82479_);
        int startY = Mth.m_14107_((double)startPos.f_82480_);
        int startZ = Mth.m_14107_((double)startPos.f_82481_);
        int signX = Mth.m_14205_((double)travel.f_82479_);
        int signY = Mth.m_14205_((double)travel.f_82480_);
        int signZ = Mth.m_14205_((double)travel.f_82481_);
        double invDirX = signX == 0 ? Double.MAX_VALUE : (double)signX / travel.f_82479_;
        double invDirY = signY == 0 ? Double.MAX_VALUE : (double)signY / travel.f_82480_;
        double invDirZ = signZ == 0 ? Double.MAX_VALUE : (double)signZ / travel.f_82481_;
        double targetMaxX = invDirX * (signX > 0 ? 1.0 - Mth.m_14185_((double)startPos.f_82479_) : Mth.m_14185_((double)startPos.f_82479_));
        double targetMaxY = invDirY * (signY > 0 ? 1.0 - Mth.m_14185_((double)startPos.f_82480_) : Mth.m_14185_((double)startPos.f_82480_));
        double targetMaxZ = invDirZ * (signZ > 0 ? 1.0 - Mth.m_14185_((double)startPos.f_82481_) : Mth.m_14185_((double)startPos.f_82481_));
        int stepsTaken = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        while (targetMaxX <= 1.0 || targetMaxY <= 1.0 || targetMaxZ <= 1.0) {
            if (targetMaxX < targetMaxY) {
                if (targetMaxX < targetMaxZ) {
                    startX += signX;
                    targetMaxX += invDirX;
                } else {
                    startZ += signZ;
                    targetMaxZ += invDirZ;
                }
            } else if (targetMaxY < targetMaxZ) {
                startY += signY;
                targetMaxY += invDirY;
            } else {
                startZ += signZ;
                targetMaxZ += invDirZ;
            }
            if (stepsTaken++ > 16) break;
            Optional<Vec3> intersectionPoint = BlockPosUtils.clip(startX, startY, startZ, startX + 1, startY + 1, startZ + 1, startPos, endPos);
            if (intersectionPoint.isEmpty()) continue;
            Vec3 hitPoint = intersectionPoint.get();
            double x = Mth.m_14008_((double)hitPoint.f_82479_, (double)((double)startX + (double)1.0E-5f), (double)((double)startX + 1.0 - (double)1.0E-5f));
            double y = Mth.m_14008_((double)hitPoint.f_82480_, (double)((double)startY + (double)1.0E-5f), (double)((double)startY + 1.0 - (double)1.0E-5f));
            double z = Mth.m_14008_((double)hitPoint.f_82481_, (double)((double)startZ + (double)1.0E-5f), (double)((double)startZ + 1.0 - (double)1.0E-5f));
            int maxX = Mth.m_14107_((double)(x + box.m_82362_()));
            int maxY = Mth.m_14107_((double)(y + box.m_82376_()));
            int maxZ = Mth.m_14107_((double)(z + box.m_82385_()));
            for (int localX = startX; localX <= maxX; ++localX) {
                for (int localY = startY; localY <= maxY; ++localY) {
                    for (int localZ = startZ; localZ <= maxZ; ++localZ) {
                        if (!visitedPositions.add(BlockPos.m_121882_((int)localX, (int)localY, (int)localZ)) || visitor.visit((BlockPos)mutable.m_122178_(localX, localY, localZ), stepsTaken)) continue;
                        return -1;
                    }
                }
            }
        }
        return stepsTaken;
    }

    public static Optional<Vec3> clip(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vec3 start, Vec3 end) {
        double[] distances = new double[]{1.0};
        double dirX = end.f_82479_ - start.f_82479_;
        double dirY = end.f_82480_ - start.f_82480_;
        double dirZ = end.f_82481_ - start.f_82481_;
        Direction direction = BlockPosUtils.getDirection(minX, minY, minZ, maxX, maxY, maxZ, start, distances, null, dirX, dirY, dirZ);
        if (direction == null) {
            return Optional.empty();
        }
        double distance = distances[0];
        return Optional.of(start.m_82520_(distance * dirX, distance * dirY, distance * dirZ));
    }

    @Nullable
    private static Direction getDirection(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vec3 start, double[] minDistance, @Nullable Direction prevDirection, double dirX, double dirY, double dirZ) {
        if (dirX > 1.0E-7) {
            prevDirection = BlockPosUtils.clipPoint(minDistance, prevDirection, dirX, dirY, dirZ, minX, minY, maxY, minZ, maxZ, Direction.WEST, start.f_82479_, start.f_82480_, start.f_82481_);
        } else if (dirX < -1.0E-7) {
            prevDirection = BlockPosUtils.clipPoint(minDistance, prevDirection, dirX, dirY, dirZ, maxX, minY, maxY, minZ, maxZ, Direction.EAST, start.f_82479_, start.f_82480_, start.f_82481_);
        }
        if (dirY > 1.0E-7) {
            prevDirection = BlockPosUtils.clipPoint(minDistance, prevDirection, dirY, dirZ, dirX, minY, minZ, maxZ, minX, maxX, Direction.DOWN, start.f_82480_, start.f_82481_, start.f_82479_);
        } else if (dirY < -1.0E-7) {
            prevDirection = BlockPosUtils.clipPoint(minDistance, prevDirection, dirY, dirZ, dirX, maxY, minZ, maxZ, minX, maxX, Direction.UP, start.f_82480_, start.f_82481_, start.f_82479_);
        }
        if (dirZ > 1.0E-7) {
            prevDirection = BlockPosUtils.clipPoint(minDistance, prevDirection, dirZ, dirX, dirY, minZ, minX, maxX, minY, maxY, Direction.NORTH, start.f_82481_, start.f_82479_, start.f_82480_);
        } else if (dirZ < -1.0E-7) {
            prevDirection = BlockPosUtils.clipPoint(minDistance, prevDirection, dirZ, dirX, dirY, maxZ, minX, maxX, minY, maxY, Direction.SOUTH, start.f_82481_, start.f_82479_, start.f_82480_);
        }
        return prevDirection;
    }

    @Nullable
    private static Direction clipPoint(double[] minDistance, @Nullable Direction prevDirection, double mainAxisDir, double secondAxisDir, double thirdAxisDir, double facePosition, double secondAxisMin, double secondAxisMax, double thirdAxisMin, double thirdAxisMax, Direction hitDirection, double startMain, double startSecond, double startThird) {
        double intersectionTime = (facePosition - startMain) / mainAxisDir;
        double secondAxisPos = startSecond + intersectionTime * secondAxisDir;
        double thirdAxisPos = startThird + intersectionTime * thirdAxisDir;
        if (0.0 < intersectionTime && intersectionTime < minDistance[0] && secondAxisMin - 1.0E-7 < secondAxisPos && secondAxisPos < secondAxisMax + 1.0E-7 && thirdAxisMin - 1.0E-7 < thirdAxisPos && thirdAxisPos < thirdAxisMax + 1.0E-7) {
            minDistance[0] = intersectionTime;
            return hitDirection;
        }
        return prevDirection;
    }

    @FunctionalInterface
    public static interface BlockStepVisitor {
        public boolean visit(BlockPos var1, int var2);
    }
}

