/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.worldgen.treedecorators;

import com.blackgear.vanillabackport.common.level.blocks.CreakingHeartBlock;
import com.blackgear.vanillabackport.common.level.blocks.blockstates.CreakingHeartState;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.registries.ModTreeDecorators;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CreakingHeartDecorator
extends TreeDecorator {
    public static final Codec<CreakingHeartDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability))).apply((Applicative)instance, CreakingHeartDecorator::new));
    private final float probability;

    public CreakingHeartDecorator(float probability) {
        this.probability = probability;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return ModTreeDecorators.CREAKING_HEART.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        ObjectArrayList logs = context.m_226068_();
        if (!logs.isEmpty() && random.m_188501_() < this.probability) {
            ArrayList validPositions = new ArrayList(context.m_226068_());
            Collections.shuffle(validPositions);
            Optional<BlockPos> validPosition = validPositions.stream().filter(pos -> {
                for (Direction direction : Direction.values()) {
                    if (context.m_226058_().m_7433_(pos.m_121945_(direction), state -> state.m_204336_(BlockTags.f_13106_))) continue;
                    return false;
                }
                return true;
            }).findFirst();
            validPosition.ifPresent(pos -> context.m_226061_(pos, (BlockState)((BlockState)ModBlocks.CREAKING_HEART.get().m_49966_().m_61124_(CreakingHeartBlock.STATE, (Comparable)((Object)CreakingHeartState.DORMANT))).m_61124_((Property)CreakingHeartBlock.NATURAL, (Comparable)Boolean.valueOf(true))));
        }
    }
}

