/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.leash;

import com.blackgear.platform.common.integration.MobInteraction;
import com.blackgear.vanillabackport.common.api.leash.Leashable;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class LeashIntegration
implements MobInteraction {
    public InteractionResult onInteract(Player player, Entity entity, InteractionHand hand) {
        List<Leashable> nearbyMobs;
        LivingEntity living;
        Leashable leashable;
        ItemStack stack = player.m_21120_(hand);
        if (!entity.m_9236_().m_5776_() && player.m_36341_() && entity instanceof Leashable && (leashable = (Leashable)entity).canBeLeashed(player) && entity.m_6084_() && (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_6162_()) && !(nearbyMobs = Leashable.leashableInArea(entity, l -> l.getLeashHolder() == player)).isEmpty()) {
            boolean attachedAny = false;
            for (Leashable target : nearbyMobs) {
                if (!target.canHaveALeashAttachedTo(entity)) continue;
                target.setLeashedTo(entity, true);
                attachedAny = true;
            }
            if (attachedAny) {
                entity.m_9236_().m_220407_(GameEvent.f_223708_, entity.m_20183_(), GameEvent.Context.m_223717_((Entity)player));
                entity.m_216990_(SoundEvents.f_12087_);
                return InteractionResult.SUCCESS;
            }
        }
        if (stack.m_150930_(Items.f_42574_) && this.shearOffAllLeashConnections(entity, player)) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        if (entity.m_6084_() && entity instanceof Leashable) {
            leashable = (Leashable)entity;
            if (leashable.getLeashHolder() == player) {
                if (!entity.m_9236_().m_5776_()) {
                    leashable.dropLeash(true, !player.m_7500_());
                    entity.m_9236_().m_214171_(GameEvent.f_223708_, entity.m_20182_(), GameEvent.Context.m_223717_((Entity)player));
                    entity.m_216990_(SoundEvents.f_12033_);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.m_150930_(Items.f_42655_) && !(leashable.getLeashHolder() instanceof Player)) {
                if (!entity.m_9236_().m_5776_() && leashable.canHaveALeashAttachedTo((Entity)player)) {
                    if (leashable.isLeashed()) {
                        leashable.dropLeash(true, true);
                    }
                    leashable.setLeashedTo((Entity)player, true);
                    entity.m_216990_(SoundEvents.f_12087_);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean shearOffAllLeashConnections(Entity entity, Player player) {
        Level level;
        boolean sheared = LeashIntegration.dropAllLeashConnections(entity, player);
        if (sheared && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_247517_(null, entity.m_20183_(), SoundEvents.f_12344_, player != null ? player.m_5720_() : entity.m_5720_());
        }
        return sheared;
    }

    public static boolean dropAllLeashConnections(Entity entity, @Nullable Player player) {
        Leashable leashable;
        boolean dropConnections;
        List<Leashable> leashed = Leashable.leashableLeashedTo(entity);
        boolean bl = dropConnections = !leashed.isEmpty();
        if (entity instanceof Leashable && (leashable = (Leashable)entity).isLeashed()) {
            leashable.dropLeash(true, true);
            dropConnections = true;
        }
        for (Leashable leashable2 : leashed) {
            leashable2.dropLeash(true, true);
        }
        if (dropConnections) {
            entity.m_146852_(GameEvent.f_157781_, (Entity)player);
            return true;
        }
        return false;
    }
}

