/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configureddefaults.handler;

import fuzs.configureddefaults.ConfiguredDefaults;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CopyDefaultsHandler {
    public static final String DEFAULTS_DIRECTORY = "configureddefaults";
    public static final String README_FILE = "README.md";
    private static final String README_CONTENTS = "# %1$s\n\nThis whole directory servers as a synchronized mirror of `.minecraft`. Every sub-directory and / or file placed within will be copied to the main `.minecraft` directory during game launch if the directory / file is not already present.\nThere is no way of overriding an existing file, a copy will only be made when the target destination is empty.\n\nPlease note that due to the way Minecraft handles `options.txt` specifically it is sufficient to include only the options you want to set a preset for. All missing options will be filled in using their internal defaults when the file is read by the game.\n\nExamples:\n- `.minecraft/%2$s/options.txt` will be copied to `.minecraft/options.txt` if not already present\n- `.minecraft/%2$s/config/jei/jei.toml` will be copied to `.minecraft/config/jei/jei.toml` if not already present\n\nNote that this `README.md` file is excluded from being copied to `.minecraft`.\n".formatted("Configured Defaults", "configureddefaults");
    private static final String OPTIONS_FILE = "options.txt";
    private static boolean initialized;

    public static void initialize(Path path, boolean mergeOptions) {
        if (!initialized) {
            initialized = true;
            ConfiguredDefaults.LOGGER.info("Applying default files...");
            try {
                path = path.toAbsolutePath();
                CopyDefaultsHandler.setupIfNecessary(path);
                CopyDefaultsHandler.copyFiles(path, mergeOptions);
                if (mergeOptions) {
                    CopyDefaultsHandler.mergeOptions(path);
                }
            }
            catch (IOException exception) {
                ConfiguredDefaults.LOGGER.error("Failed to setup default files", (Throwable)exception);
            }
        }
    }

    private static void setupIfNecessary(Path path) throws IOException {
        Path readmePath;
        Path defaultPresetsPath = path.resolve(DEFAULTS_DIRECTORY);
        Path gameParentPath = path.getParent();
        if (Files.notExists(defaultPresetsPath, new LinkOption[0])) {
            if (!defaultPresetsPath.toFile().mkdir()) {
                ConfiguredDefaults.LOGGER.info("Failed to create fresh '{}' directory", (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, defaultPresetsPath));
                return;
            }
            ConfiguredDefaults.LOGGER.info("Created fresh '{}' directory", (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, defaultPresetsPath));
        }
        if (Files.notExists(readmePath = defaultPresetsPath.resolve(README_FILE), new LinkOption[0])) {
            Files.write(readmePath, README_CONTENTS.getBytes(), new OpenOption[0]);
            ConfiguredDefaults.LOGGER.info("Created fresh '{}' file", (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, readmePath));
        }
    }

    private static void copyFiles(Path path, boolean mergeOptions) throws IOException {
        Path defaultPresetsPath = path.resolve(DEFAULTS_DIRECTORY);
        Path gameParentPath = path.getParent();
        Set<Path> exclusionPaths = CopyDefaultsHandler.getExclusionPaths(defaultPresetsPath, mergeOptions);
        Files.walk(defaultPresetsPath, new FileVisitOption[0]).forEach(sourcePath -> {
            if (!exclusionPaths.contains(sourcePath)) {
                try {
                    Path targetPath = CopyDefaultsHandler.relativizeAndNormalize(path, defaultPresetsPath.relativize((Path)sourcePath));
                    if (sourcePath.toFile().exists() && !targetPath.toFile().exists()) {
                        try {
                            Files.copy(sourcePath, targetPath, new CopyOption[0]);
                            ConfiguredDefaults.LOGGER.info("Copied '{}' to '{}'", (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, sourcePath), (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, targetPath));
                        }
                        catch (IOException e) {
                            ConfiguredDefaults.LOGGER.info("Failed to copy '{}' to '{}'", (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, sourcePath), (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, targetPath));
                        }
                    }
                }
                catch (Throwable throwable) {
                    ConfiguredDefaults.LOGGER.error("Failed to copy '{}'", (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, sourcePath), (Object)throwable);
                }
            }
        });
    }

    private static Set<Path> getExclusionPaths(Path defaultPresetsPath, boolean mergeOptions) {
        HashSet<Path> paths = new HashSet<Path>(Arrays.asList(defaultPresetsPath, defaultPresetsPath.resolve(README_FILE), defaultPresetsPath.resolve(".DS_Store")));
        if (mergeOptions) {
            paths.add(defaultPresetsPath.resolve(OPTIONS_FILE));
        }
        return paths;
    }

    private static Path relativizeAndNormalize(Path parentPath, Path path) {
        return parentPath.toAbsolutePath().relativize(path.toAbsolutePath()).normalize();
    }

    private static void mergeOptions(Path path) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        Path optionsPath = path.resolve(OPTIONS_FILE);
        CopyDefaultsHandler.loadOptions(optionsPath, options, false);
        int size = options.size();
        if (CopyDefaultsHandler.loadOptions(path.resolve(DEFAULTS_DIRECTORY).resolve(OPTIONS_FILE), options, true) && options.size() != size) {
            CopyDefaultsHandler.saveOptions(optionsPath, options);
        }
    }

    private static boolean loadOptions(Path path, Map<String, String> options, boolean reportOption) {
        if (Files.exists(path, new LinkOption[0])) {
            boolean bl;
            block9: {
                BufferedReader bufferedReader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                try {
                    bufferedReader.lines().forEach(string -> {
                        try {
                            Iterator<String> iterator = Arrays.asList(string.split(":", 2)).iterator();
                            if (options.putIfAbsent(iterator.next(), iterator.next()) == null && reportOption) {
                                ConfiguredDefaults.LOGGER.info("Setting new option: {}", string);
                            }
                        }
                        catch (Exception exception) {
                            ConfiguredDefaults.LOGGER.warn("Skipping bad option: {}", string);
                        }
                    });
                    bl = true;
                    if (bufferedReader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        ConfiguredDefaults.LOGGER.error("Failed to load options", throwable3);
                    }
                }
                bufferedReader.close();
            }
            return bl;
        }
        return false;
    }

    private static void saveOptions(Path path, Map<String, String> options) {
        if (!options.isEmpty()) {
            try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));){
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    printWriter.print(entry.getKey());
                    printWriter.print(':');
                    printWriter.println(entry.getValue());
                }
            }
            catch (Throwable throwable) {
                ConfiguredDefaults.LOGGER.error("Failed to save options", throwable);
            }
        }
    }
}

