/*
 * Decompiled with CFR 0.152.
 */
package me.talilon.minecraft.crawlondemand;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.loading.FMLPaths;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FMLPaths.CONFIGDIR.get().toFile(), "crawlondemand.json");
    public boolean onlyAllowCrawlingOnGround = false;
    private static ModConfig INSTANCE;

    public static ModConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = ModConfig.load();
        }
        return INSTANCE;
    }

    private static ModConfig load() {
        ModConfig config;
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                if (config == null) {
                    config = new ModConfig();
                }
            }
            catch (IOException e) {
                config = new ModConfig();
            }
        } else {
            config = new ModConfig();
            ModConfig.save(config);
        }
        return config;
    }

    public static void save(ModConfig config) {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

