/*
 * Decompiled with CFR 0.152.
 */
package me.talilon.minecraft.crawlondemand;

import com.mojang.logging.LogUtils;
import me.talilon.minecraft.crawlondemand.ClientCrawlOnDemand;
import me.talilon.minecraft.crawlondemand.ModConfig;
import me.talilon.minecraft.crawlondemand.capabilities.CapabilityHandler;
import me.talilon.minecraft.crawlondemand.networking.PoseChangePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

@Mod(value="crawlondemand")
public class CrawlOnDemand {
    public static final String MOD_ID = "crawlondemand";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("crawlondemand", "main"), () -> "1", "1"::equals, "1"::equals);

    public CrawlOnDemand() {
        LOGGER.debug("Loading");
        if (FMLLoader.getDist() == Dist.CLIENT) {
            LOGGER.debug("Client detected, loading ClientCrawlOnDemand");
            new ClientCrawlOnDemand();
        }
        CrawlOnDemand.setup();
    }

    public static void setup() {
        int packetId = 0;
        INSTANCE.registerMessage(packetId++, PoseChangePacket.class, (packet, packetBuffer) -> packetBuffer.writeBoolean(packet.isCrawling()), packetBuffer -> new PoseChangePacket(packetBuffer.readBoolean()), (packet, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                assert (player != null);
                if (packet.isCrawling() && ModConfig.getInstance().onlyAllowCrawlingOnGround && !player.m_20096_()) {
                    return;
                }
                player.getCapability(CapabilityHandler.CRAWL_CAPABILITY).ifPresent(c -> c.setIsCrawling(packet.isCrawling()));
            });
            context.setPacketHandled(true);
        });
    }
}

