/*
 * Decompiled with CFR 0.152.
 */
package net.nathanthecraziest.spawnersplus.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.nathanthecraziest.spawnersplus.config.Config;

public class SpawnersPlusConfig {
    private static final HashMap<String, Float> DROP_RATE = new HashMap();

    public static float getFloatValue(String key) {
        if (!DROP_RATE.containsKey(key)) {
            System.out.println(key);
        }
        return ((Float)DROP_RATE.getOrDefault(key, null)).floatValue();
    }

    public static void init() {
        DROP_RATE.put("zombie_soul", Float.valueOf(0.04f));
        DROP_RATE.put("skeleton_soul", Float.valueOf(0.04f));
        DROP_RATE.put("spider_soul", Float.valueOf(0.04f));
        DROP_RATE.put("cave_spider_soul", Float.valueOf(0.07f));
        DROP_RATE.put("blaze_soul", Float.valueOf(0.05f));
        DROP_RATE.put("magma_cube_soul", Float.valueOf(0.02f));
        DROP_RATE.put("stray_soul", Float.valueOf(0.0f));
        DROP_RATE.put("wither_skeleton_soul", Float.valueOf(0.0f));
        DROP_RATE.put("husk_soul", Float.valueOf(0.04f));
        DROP_RATE.put("drowned_soul", Float.valueOf(0.0f));
        DROP_RATE.put("creeper_soul", Float.valueOf(0.05f));
    }

    public static void loadConfig() {
        JsonObject json = Config.getJsonObject(Config.readFile(new File("config/spawnersplus/soul_drop_rates.json")));
        for (Map.Entry entry : json.entrySet()) {
            DROP_RATE.put((String)entry.getKey(), Float.valueOf(((JsonElement)entry.getValue()).getAsFloat()));
        }
    }

    public static void generateConfigs(boolean overwrite) {
        StringBuilder config = new StringBuilder("{\n");
        int i = 0;
        for (String key : DROP_RATE.keySet()) {
            config.append("  \"").append(key).append("\": ").append(DROP_RATE.get(key));
            if (++i < DROP_RATE.size()) {
                config.append(",");
            }
            config.append("\n");
        }
        config.append("}");
        Config.createFile("config/spawnersplus/soul_drop_rates.json", config.toString(), overwrite);
    }
}

