/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.capability.entity;

import com.legacy.lost_aether.LostContentConfig;
import com.legacy.lost_aether.capability.entity.IWingedAnimal;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.animal.Animal;
import net.minecraftforge.common.capabilities.Capability;

public class WingedAnimalCap
implements IWingedAnimal {
    private Animal animal;
    private byte wingTypeId = 0;
    private static final String WING_TYPE_KEY = "WingType";

    public WingedAnimalCap() {
    }

    public WingedAnimalCap(Animal animal) {
        this.animal = animal;
    }

    @Override
    public Capability<IWingedAnimal> getDefaultInstance() {
        return IWingedAnimal.INSTANCE;
    }

    @Nullable
    public static IWingedAnimal get(Animal animal) {
        return WingedAnimalCap.getIfPresent(animal, wingedAnimal -> wingedAnimal, () -> null);
    }

    public static <E extends Animal> void ifPresent(E animal, Consumer<IWingedAnimal> action) {
        Optional optional;
        if (animal != null && (optional = animal.getCapability(IWingedAnimal.INSTANCE).resolve()).isPresent()) {
            action.accept((IWingedAnimal)optional.get());
        }
    }

    public static <E extends Animal, R> R getIfPresent(E animal, Function<IWingedAnimal, R> action, Supplier<R> elseSupplier) {
        Optional optional;
        if (animal != null && (optional = animal.getCapability(IWingedAnimal.INSTANCE).resolve()).isPresent()) {
            return action.apply((IWingedAnimal)optional.get());
        }
        return elseSupplier.get();
    }

    @Override
    public CompoundTag writeAdditional(CompoundTag nbt) {
        nbt.m_128344_(WING_TYPE_KEY, this.getWingType());
        return nbt;
    }

    @Override
    public void read(CompoundTag nbt) {
        this.setWingType(nbt.m_128445_(WING_TYPE_KEY));
    }

    @Override
    public Animal getAnimal() {
        return this.animal;
    }

    @Override
    public byte getWingType() {
        return this.wingTypeId;
    }

    @Override
    public void setWingType(byte id) {
        this.wingTypeId = id;
    }

    @Override
    public void setWingType(WingType type) {
        this.setWingType((byte)type.ordinal());
    }

    @Override
    public boolean shouldDisplayWings() {
        return this.getWingType() > 0 && (Boolean)LostContentConfig.WORLD.mutationWingColors.get() != false;
    }

    public static enum WingType {
        GOLD,
        SILVER,
        BRONZE;

    }
}

