/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.layer;

import mod.azure.azurelib.cache.texture.AutoGlowingTexture;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.layer.AzRenderLayer;
import mod.azure.azurelib.util.client.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AzAutoGlowingLayer<K, T>
implements AzRenderLayer<K, T> {
    @Override
    public void preRender(AzRendererPipelineContext<K, T> context) {
    }

    @Override
    public void render(AzRendererPipelineContext<K, T> context) {
        AzRendererPipeline<K, T> renderPipeline = context.rendererPipeline();
        RenderType renderType = this.determineRenderType(context);
        if (renderType != null) {
            context.setRenderType(renderType);
            context.setPackedLight(this.getPackedLight(context));
            context.setVertexConsumer(context.multiBufferSource().m_6299_(renderType));
            renderPipeline.reRender(context);
        }
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<K, T> context, AzBone bone) {
    }

    protected int getPackedLight(AzRendererPipelineContext<K, T> context) {
        return 0xF00000;
    }

    protected RenderType determineRenderType(AzRendererPipelineContext<K, T> context) {
        T animatable = context.animatable();
        AzRendererConfig<K, T> config = context.rendererPipeline().config();
        ResourceLocation textureLocation = config.textureLocation(context.currentEntity(), animatable);
        if (!(animatable instanceof Entity)) {
            return AutoGlowingTexture.getRenderType(textureLocation);
        }
        Entity entity = (Entity)animatable;
        boolean isInvisible = entity.m_20145_();
        boolean appearsGlowing = Minecraft.m_91087_().m_91314_(entity);
        boolean isPlayerInvisible = entity.m_20177_(ClientUtils.getClientPlayer());
        if (isInvisible) {
            if (!isPlayerInvisible) {
                return RenderType.m_110467_((ResourceLocation)AutoGlowingTexture.getEmissiveResource(textureLocation));
            }
            if (appearsGlowing) {
                return RenderType.m_110491_((ResourceLocation)AutoGlowingTexture.getEmissiveResource(textureLocation));
            }
            return null;
        }
        if (appearsGlowing) {
            return AutoGlowingTexture.getOutlineRenderType(textureLocation);
        }
        return AutoGlowingTexture.getRenderType(textureLocation);
    }
}

