/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.layer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import java.util.function.Function;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.render.layer.AzRenderLayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;

public class AzArmorTrimLayer
implements AzRenderLayer<UUID, ItemStack> {
    public final ResourceLocation textureBaseLocation;
    public final Function<ArmorTrim, ResourceLocation> texturePermutations;

    public AzArmorTrimLayer(ResourceLocation baseTexture) {
        this(baseTexture, true);
    }

    public AzArmorTrimLayer(ResourceLocation baseTexture, boolean supportPatterns) {
        this(baseTexture, supportPatterns ? trim -> {
            TrimPattern pattern = (TrimPattern)trim.m_266429_().m_203334_();
            TrimMaterial material = (TrimMaterial)trim.m_266210_().m_203334_();
            String patternName = pattern.f_266052_().m_135815_();
            return new ResourceLocation(baseTexture.m_135827_(), baseTexture.m_135815_() + "_" + patternName + "_" + material.f_265854_());
        } : trim -> {
            TrimMaterial material = (TrimMaterial)trim.m_266210_().m_203334_();
            return new ResourceLocation(baseTexture.m_135827_(), baseTexture.m_135815_() + "_" + material.f_265854_());
        });
    }

    public AzArmorTrimLayer(ResourceLocation baseTexture, Function<ArmorTrim, ResourceLocation> textureLocationPermutations) {
        this.textureBaseLocation = baseTexture;
        this.texturePermutations = textureLocationPermutations;
    }

    @Override
    public void preRender(AzRendererPipelineContext<UUID, ItemStack> context) {
    }

    @Override
    public void render(AzRendererPipelineContext<UUID, ItemStack> context) {
        AzArmorRendererPipelineContext armorPipelineContext = (AzArmorRendererPipelineContext)context;
        ItemStack itemstack = armorPipelineContext.currentStack();
        if (itemstack == null) {
            return;
        }
        Entity currentEntity = armorPipelineContext.currentEntity();
        if (currentEntity == null) {
            return;
        }
        ArmorTrim.m_266285_((RegistryAccess)currentEntity.m_9236_().m_9598_(), (ItemStack)itemstack).ifPresent(armorTrim -> {
            ModelManager bakery = Minecraft.m_91087_().m_91304_();
            TextureAtlas armorTrimsAtlas = bakery.m_119428_(Sheets.f_265912_);
            AzRendererPipeline renderPipeline = context.rendererPipeline();
            ResourceLocation trimLocation = this.texturePermutations.apply((ArmorTrim)armorTrim);
            TextureAtlasSprite sprite = armorTrimsAtlas.m_118316_(trimLocation);
            RenderType renderType = Sheets.m_266442_();
            VertexConsumer vertexConsumer = sprite.m_118381_(ItemRenderer.m_115184_((MultiBufferSource)context.multiBufferSource(), (RenderType)renderType, (boolean)false, (boolean)itemstack.m_41790_()));
            if (context.renderType() != null) {
                context.setRenderType(renderType);
                context.setVertexConsumer(vertexConsumer);
                renderPipeline.reRender(context);
            }
        });
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<UUID, ItemStack> azRendererPipelineContext, AzBone azBone) {
    }
}

