/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.value;

import java.lang.reflect.Field;
import mod.azure.azurelib.config.ConfigUtils;
import mod.azure.azurelib.config.adapter.TypeAdapter;
import mod.azure.azurelib.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.config.format.IConfigFormat;
import mod.azure.azurelib.config.value.ConfigValue;
import mod.azure.azurelib.config.value.IntegerValue;
import mod.azure.azurelib.config.value.ValueData;
import net.minecraft.network.FriendlyByteBuf;

public class LongValue
extends IntegerValue<Long> {
    public LongValue(ValueData<Long> valueData) {
        super(valueData, IntegerValue.Range.unboundedLong());
    }

    @Override
    public Long getCorrectedValue(Long in) {
        if (this.range == null) {
            return in;
        }
        if (!this.range.isWithin(in)) {
            long corrected = this.range.clamp(in);
            ConfigUtils.logCorrectedMessage(this.getId(), in, corrected);
            return corrected;
        }
        return in;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeLong(this.getId(), (Long)this.get());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(format.readLong(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new LongValue(ValueData.of(name, Long.valueOf((Long)value), context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            buffer.writeLong(((Long)value.get()).longValue());
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            return buffer.readLong();
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setLong(instance, (Long)value);
        }
    }
}

