/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.config.ConfigHolder;
import mod.azure.azurelib.config.client.IValidationHandler;
import mod.azure.azurelib.config.client.screen.ConfigScreen;
import mod.azure.azurelib.config.client.screen.DialogScreen;
import mod.azure.azurelib.config.client.widget.ConfigEntryWidget;
import mod.azure.azurelib.config.io.ConfigIO;
import mod.azure.azurelib.config.validate.NotificationSeverity;
import mod.azure.azurelib.config.value.ConfigValue;
import mod.azure.azurelib.config.value.ObjectValue;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.joml.Matrix4f;

public abstract class AbstractConfigScreen
extends Screen {
    public static final int HEADER_HEIGHT = 35;
    public static final int FOOTER_HEIGHT = 30;
    public static final Marker MARKER = MarkerManager.getMarker((String)"Screen");
    protected final Screen last;
    protected final String configId;
    protected int index;
    protected int pageSize;

    protected AbstractConfigScreen(Component title, Screen previous, String configId) {
        super(title);
        this.last = previous;
        this.configId = configId;
    }

    public void m_7379_() {
        super.m_7379_();
        this.saveConfig(true);
    }

    public static void renderScrollbar(GuiGraphics graphics, int x, int y, int width, int height, int index, int valueCount, int paging) {
        if (valueCount <= paging) {
            return;
        }
        double step = (double)height / (double)valueCount;
        int min = Mth.m_14107_((double)((double)index * step));
        int max = Mth.m_14165_((double)((double)(index + paging) * step));
        int y1 = y + min;
        int y2 = y + max;
        graphics.m_280509_(x, y, x + width, y + height, -16777216);
        graphics.m_280509_(x, y1, x + width, y2, -7829368);
        graphics.m_280509_(x, y1, x + width - 1, y2 - 1, -1118482);
        graphics.m_280509_(x + 1, y1 + 1, x + width - 1, y2 - 1, -3355444);
    }

    protected void addFooter() {
        int centerY = this.f_96544_ - 30 + 5;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ConfigEntryWidget.BACK, this::buttonBackClicked).m_252794_(20, centerY).m_253046_(50, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ConfigEntryWidget.REVERT_DEFAULTS, this::buttonRevertToDefaultClicked).m_252794_(75, centerY).m_253046_(120, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ConfigEntryWidget.REVERT_CHANGES, this::buttonRevertChangesClicked).m_252794_(200, centerY).m_253046_(120, 20).m_253136_());
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    protected Screen getFirstNonConfigScreen() {
        Screen screen = this.last;
        while (screen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)screen;
            screen = configScreen.last;
        }
        return screen;
    }

    private void buttonBackClicked(Button button) {
        this.f_96541_.m_91152_(this.last);
        this.saveConfig();
    }

    private void buttonRevertToDefaultClicked(Button button) {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_DEFAULTS, new Component[]{ConfigEntryWidget.REVERT_DEFAULTS_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            AzureLib.LOGGER.info(MARKER, "Reverting config {} to default values", (Object)this.configId);
            ConfigHolder.getConfig(this.configId).ifPresent(holder -> {
                this.revertToDefault(holder.values());
                ConfigIO.saveClientValues(holder);
            });
            this.backToConfigList();
        });
        this.f_96541_.m_91152_((Screen)dialog);
    }

    private void buttonRevertChangesClicked(Button button) {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_CHANGES, new Component[]{ConfigEntryWidget.REVERT_CHANGES_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            ConfigHolder.getConfig(this.configId).ifPresent(ConfigIO::reloadClientValues);
            this.backToConfigList();
        });
        this.f_96541_.m_91152_((Screen)dialog);
    }

    private void revertToDefault(Collection<ConfigValue<?>> configValues) {
        configValues.forEach(val -> {
            if (val instanceof ObjectValue) {
                ObjectValue objVal = (ObjectValue)val;
                this.revertToDefault(((Map)objVal.get()).values());
            } else {
                val.useDefaultValue();
            }
        });
    }

    private void backToConfigList() {
        this.f_96541_.m_91152_(this.getFirstNonConfigScreen());
        this.saveConfig();
    }

    private void saveConfig() {
        this.saveConfig(false);
    }

    private void saveConfig(boolean force) {
        if (force || !(this.last instanceof AbstractConfigScreen)) {
            ConfigHolder.getConfig(this.configId).ifPresent(ConfigIO::saveClientValues);
        }
    }

    public void renderNotification(NotificationSeverity severity, GuiGraphics graphics, List<FormattedCharSequence> texts, int mouseX, int mouseY) {
        if (!texts.isEmpty()) {
            int maxTextWidth = 0;
            int iconOffset = 13;
            for (FormattedCharSequence textComponent : texts) {
                int textWidth = this.f_96547_.m_92724_(textComponent);
                if (!severity.isOkStatus()) {
                    textWidth += iconOffset;
                }
                if (textWidth <= maxTextWidth) continue;
                maxTextWidth = textWidth;
            }
            int startX = mouseX + 12;
            int startY = mouseY - 12;
            int heightOffset = 8;
            if (texts.size() > 1) {
                heightOffset += 2 + (texts.size() - 1) * 10;
            }
            if (startX + maxTextWidth > this.f_96543_) {
                startX -= 28 + maxTextWidth;
            }
            if (startY + heightOffset + 6 > this.f_96544_) {
                startY = this.f_96544_ - heightOffset - 6;
            }
            int background = severity.background;
            int fadeMin = severity.fadeMin;
            int fadeMax = severity.fadeMax;
            int zIndex = 400;
            Tesselator tessellator = Tesselator.m_85913_();
            RenderSystem.setShader(GameRenderer::m_172811_);
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
            graphics.m_280120_(startX - 3, startY - 4, startX + maxTextWidth + 3, startY - 3, zIndex, background, background);
            graphics.m_280120_(startX - 3, startY + heightOffset + 3, startX + maxTextWidth + 3, startY + heightOffset + 4, zIndex, background, background);
            graphics.m_280120_(startX - 3, startY - 3, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.m_280120_(startX - 4, startY - 3, startX - 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.m_280120_(startX + maxTextWidth + 3, startY - 3, startX + maxTextWidth + 4, startY + heightOffset + 3, zIndex, background, background);
            graphics.m_280120_(startX - 3, startY - 3 + 1, startX - 3 + 1, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.m_280120_(startX + maxTextWidth + 2, startY - 3 + 1, startX + maxTextWidth + 3, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.m_280120_(startX - 3, startY - 3, startX + maxTextWidth + 3, startY - 3 + 1, zIndex, fadeMin, fadeMin);
            graphics.m_280120_(startX - 3, startY + heightOffset + 2, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, fadeMax, fadeMax);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            if (!severity.isOkStatus()) {
                ResourceLocation icon = severity.getIcon();
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                float min = -0.5f;
                float max = 8.5f;
                bufferbuilder.m_252986_(matrix4f, (float)startX + min, (float)startY + min, (float)zIndex).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f, (float)startX + min, (float)startY + max, (float)zIndex).m_7421_(0.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f, (float)startX + max, (float)startY + max, (float)zIndex).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f, (float)startX + max, (float)startY + min, (float)zIndex).m_7421_(1.0f, 0.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            }
            RenderSystem.disableBlend();
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            int textOffset = severity.isOkStatus() ? 0 : iconOffset;
            for (int i = 0; i < texts.size(); ++i) {
                FormattedCharSequence textComponent = texts.get(i);
                if (textComponent != null) {
                    this.f_96547_.m_272191_(textComponent, (float)startX + (float)textOffset, (float)startY, -1, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                if (i == 0) {
                    startY += 2;
                }
                startY += 10;
            }
            bufferSource.m_109911_();
        }
    }

    protected <T> void initializeGuiValue(ConfigValue<T> value, IValidationHandler handler) {
        T t = value.get();
        value.setWithValidationHandler(t, handler);
    }
}

